/*
 *  Copyright (c) 2010 Dmitry Kazakov <dimula73@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __KIS_LEGACY_TILE_COMPRESSOR_H
#define __KIS_LEGACY_TILE_COMPRESSOR_H

#include "kis_abstract_tile_compressor.h"


class KRITAIMAGE_EXPORT KisLegacyTileCompressor : public KisAbstractTileCompressor
{
public:
    KisLegacyTileCompressor();
    ~KisLegacyTileCompressor() override;

    bool writeTile(KisTileSP tile, KisPaintDeviceWriter &store) override;
    bool readTile(QIODevice *stream, KisTiledDataManager *dm) override;


    void compressTileData(KisTileData *tileData,quint8 *buffer,
                          qint32 bufferSize, qint32 &bytesWritten) override;
    bool decompressTileData(quint8 *buffer, qint32 bufferSize, KisTileData *tileData) override;
    qint32 tileDataBufferSize(KisTileData *tileData) override;

private:
    /**
     * Quite self describing
     */
    qint32 maxHeaderLength();

    /**
     * Writes header into the buffer. Buffer size
     * should be maxHeaderLength() + 1 bytes at least
     * (to fit terminating '\0')
     */
    bool writeHeader(KisTileSP tile, quint8 *buffer);
};

#endif /* __KIS_LEGACY_TILE_COMPRESSOR_H */

