/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kdebindings.java.krossjava;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.kde.kdebindings.java.krossjava.KrossQExtension;

public class KrossClassLoader
extends URLClassLoader {
    private static KrossClassLoader kcl = null;
    private Map storedClasses = new Hashtable();
    private Map extensions = new Hashtable();
    public static final int UNKNOWN_DATA = 0;
    public static final int CLASS_DATA = 1;
    public static final int JAR_DATA = 2;
    static /* synthetic */ Class class$org$kde$kdebindings$java$krossjava$KrossClassLoader;

    public KrossClassLoader() {
        super(new URL[]{}, (class$org$kde$kdebindings$java$krossjava$KrossClassLoader == null ? (class$org$kde$kdebindings$java$krossjava$KrossClassLoader = KrossClassLoader.class$("org.kde.kdebindings.java.krossjava.KrossClassLoader")) : class$org$kde$kdebindings$java$krossjava$KrossClassLoader).getClassLoader());
        kcl = this;
    }

    public String addClass(String string, byte[] byArray) {
        switch (KrossClassLoader.getDataType(byArray)) {
            case 0: {
                System.out.println("Didn't get a valid script!");
                return "";
            }
            case 1: {
                return this.addSingleClass(string, byArray);
            }
            case 2: {
                return this.addJARData(string, byArray);
            }
        }
        System.out.println("Unknown class data!");
        return "";
    }

    public String addSingleClass(String string, byte[] byArray) {
        if (KrossClassLoader.getDataType(byArray) != 1) {
            System.out.println("Didn't get a valid classfile!");
        }
        if (this.storedClasses.containsKey(string)) {
            return ((Class)this.storedClasses.get(string)).getName();
        }
        try {
            Class<?> clazz = this.defineClass(null, byArray, 0, byArray.length);
            if (string != null && !string.equals("")) {
                this.storedClasses.put(string, clazz);
            }
            this.storedClasses.put(clazz.getName(), clazz);
            return clazz.getName();
        }
        catch (LinkageError linkageError) {
            linkageError.printStackTrace();
            return "";
        }
    }

    public String addJARData(String string, byte[] byArray) {
        Object object;
        Object object2;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        Manifest manifest = null;
        try {
            object2 = new byte[1024];
            object = zipInputStream.getNextEntry();
            while (object != null) {
                String string2 = ((ZipEntry)object).getName();
                if (string2.endsWith(".class")) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = zipInputStream.read((byte[])object2);
                    while (n > 0) {
                        byteArrayOutputStream.write((byte[])object2, 0, n);
                        n = zipInputStream.read((byte[])object2);
                    }
                    this.addSingleClass(string2, byteArrayOutputStream.toByteArray());
                } else if (string2.equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest(zipInputStream);
                }
                object = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (manifest != null) {
            object2 = manifest.getMainAttributes();
            object = ((Attributes)object2).getValue("Kross-Main");
            if (object != null) {
                return object;
            }
            return "";
        }
        return "";
    }

    public KrossQExtension addExtension(String string, long l) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        KrossQExtension krossQExtension = (KrossQExtension)this.newInstance(string, new Long(l));
        this.extensions.put(string, krossQExtension);
        return krossQExtension;
    }

    public Object newInstance(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.loadClass(string).newInstance();
    }

    public Object newInstance(String string, Object[] objectArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = this.loadClass(string);
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        Constructor<?> constructor = clazz.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    public Object newInstance(String string, Object object) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object[] objectArray = new Object[]{object};
        return this.newInstance(string, objectArray);
    }

    public static KrossQExtension importModule(String string) {
        if (kcl == null) {
            System.out.println("Oops, KCL not initialized yet!");
            return null;
        }
        if (kcl.isLoadedExtension(string)) {
            return kcl.getLoadedExtension(string);
        }
        System.out.println("Module not found: " + string);
        return null;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        if (this.storedClasses.containsKey(string)) {
            return (Class)this.storedClasses.get(string);
        }
        return super.findClass(string);
    }

    public static boolean isClassData(byte[] byArray) {
        return KrossClassLoader.getDataType(byArray) != 0;
    }

    public static int getDataType(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            return 0;
        }
        int n = KrossClassLoader.byteArrayToInt(byArray);
        if (n == -889275714) {
            return 1;
        }
        if (n == 1347093252) {
            return 2;
        }
        return 0;
    }

    public static int byteArrayToInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = (3 - i) * 8;
            n += (byArray[i] & 0xFF) << n2;
        }
        return n;
    }

    public boolean isLoadedExtension(String string) {
        return this.extensions.containsKey(string);
    }

    public KrossQExtension getLoadedExtension(String string) {
        return (KrossQExtension)this.extensions.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

