/*
  Copyright (c) 2018 Allen Winter <winter@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
#ifndef KORG_PLUGINS_LUNARPHASES_LUNARPHASES_H
#define KORG_PLUGINS_LUNARPHASES_LUNARPHASES_H

#include <EventViews/CalendarDecoration>

using namespace EventViews::CalendarDecoration;

class Lunarphases : public Decoration
{
public:
    Lunarphases();
    ~Lunarphases() override
    {
    }

    Element::List createDayElements(const QDate &) override;
    Element::List createWeekElements(const QDate &) override;

    QString info() const override;
};

class LunarphasesFactory : public DecorationFactory
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.kde.korganizer.Lunarphases")
public:
    Decoration *createPluginFactory() override
    {
        return new Lunarphases;
    }
};

#endif
