/*
   Copyright (C) 2016 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef CHECKBEFORESENDCONFIGUREWIDGET_H
#define CHECKBEFORESENDCONFIGUREWIDGET_H

#include <QWidget>
#include <MessageComposer/PluginEditorCheckBeforeSendConfigureWidget>

class QCheckBox;
class CheckBeforeSendConfigureWidget : public MessageComposer::PluginEditorCheckBeforeSendConfigureWidget
{
    Q_OBJECT
public:
    explicit CheckBeforeSendConfigureWidget(QWidget *parent = nullptr);
    ~CheckBeforeSendConfigureWidget();

    void loadSettings() Q_DECL_OVERRIDE;
    void saveSettings() Q_DECL_OVERRIDE;
    void resetSettings() Q_DECL_OVERRIDE;

private:
    QCheckBox *mCheckPlainTextMail;
    QCheckBox *mCheckMailTransport;
    QCheckBox *mCheckDuplicateEmails;
    QCheckBox *mCheckSendAttachments;
};

#endif // CHECKBEFORESENDCONFIGUREWIDGET_H
