/*
   Copyright (C) 2016 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/


#ifndef AUTOMATICADDCONTACTSCONFIGURETAB_H
#define AUTOMATICADDCONTACTSCONFIGURETAB_H

#include <QWidget>
class QTabWidget;
class QTabWidget;
class KConfigGroup;
class AutomaticAddContactsTabWidget;
class AutomaticAddContactsConfigureTab : public QWidget
{
    Q_OBJECT
public:
    explicit AutomaticAddContactsConfigureTab(QWidget *parent = Q_NULLPTR);
    ~AutomaticAddContactsConfigureTab();

    void loadSettings();
    void saveSettings();
    void resetSettings();

Q_SIGNALS:
    void configureChanged();

private:
    void initTab();
    QTabWidget *mTabWidget;
    QList<AutomaticAddContactsTabWidget *> mListTabWidget;

};

#endif // AUTOMATICADDCONTACTSCONFIGURETAB_H
