%feature("docstring") OT::IntervalMesher
"Creation of mesh of box type.

Parameters
----------
discretization : sequence of int.
    Number of intervals in each direction of the box.

Examples
--------
Create a mesh:

>>> import openturns as ot
>>> mesher = ot.IntervalMesher([5, 10])
>>> lowerbound = [0.0, 0.0]
>>> upperBound = [2.0, 4.0]
>>> interval = ot.Interval(lowerbound, upperBound)
>>> mesh = mesher.build(interval)"

// ---------------------------------------------------------------------

%feature("docstring") OT::IntervalMesher::build
"Build the mesh of box type.

Parameters
----------
interval : :class:`~openturns.Interval`
    The interval to mesh, of dimension equal to the dimension
    of `discretization`.
diamond : bool, optional
    Whether to compute rectangular cells cut into 4 triangles with the center of
    the cell as a shared vertex, or rectangular cells cut along a diagonal in dimension 2.
    Default is *IntervalMesher-UseDiamond*, see :class:`~openturns.ResourceMap`.

Returns
-------
mesh : :class:`~openturns.Mesh`
    The mesh built."

// ---------------------------------------------------------------------

%feature("docstring") OT::IntervalMesher::getDiscretization
"Accessor to the discretization.

Returns
-------
discretization : :class:`~openturns.Indices`
    Number of intervals in each direction of the box."

// ---------------------------------------------------------------------

%feature("docstring") OT::IntervalMesher::setDiscretization
"Accessor to the discretization.

Parameters
----------
discretization : sequence of int
    Number of intervals in each direction of the box."
