# getDirectoryToWatchFailedLookupLocationAtTypes

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Unc root: //vda1cs4850/

## RootDirForResolution: //vda1cs4850/

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot                                                                                      | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2                                                                                    | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3                                                                            | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4                                                                    | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                                            | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot                                                                                     | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1                                                                             | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2                                                                     | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3                                                             | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                                     | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                             | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot                                                                                      | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1                                                                              | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2                                                                      | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3                                                              | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                                      | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                              | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot                                                                                       | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1                                                                               | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2                                                                       | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3                                                               | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                                       | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                               | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                           | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                       | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                | //vda1cs4850/users/username/folderAtRoot/folder1/node_modules                                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/node_modules                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                   | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts               | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts        | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts           | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts       | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                | true      |
| //vda1cs4850/user/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/user/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/user/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/user/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/user/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/usr/node_modules/@types/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/somefile.d.ts                                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/node_modules/@types/dir/subdir/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/usr/username/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                     | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                 | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                          | //vda1cs4850/usr/username/folderAtRoot/node_modules                                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                             | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                         | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                  | //vda1cs4850/usr/username/folderAtRoot/folder1/node_modules                                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/node_modules                                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                     | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                 | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts          | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                          | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts             | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts         | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts  | //vda1cs4850/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                  | true      |
| //vda1cs4850/home/node_modules/@types/somefile.d.ts                                                                          |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/somefile.d.ts                                                                      |                                                                                                                              |           |
| //vda1cs4850/home/node_modules/@types/dir/subdir/somefile.d.ts                                                               |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/somefile.d.ts                                                                 |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/somefile.d.ts                                                             |                                                                                                                              |           |
| //vda1cs4850/home/username/node_modules/@types/dir/subdir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                    | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                         | //vda1cs4850/home/username/folderAtRoot/node_modules                                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                            | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                        | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                 | //vda1cs4850/home/username/folderAtRoot/folder1/node_modules                                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/node_modules                                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                 | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                    | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts         | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                         | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts            | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts        | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |
| //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts | //vda1cs4850/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                 | true      |

## RootDirForResolution: //vda1cs4850/home

| Location                                                                                                                     | getDirectoryToWatchFailedLookupLocation                                                                                      | Recursive |
| ---------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/node_modules/@types/somefile.d.ts                                                                               |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/somefile.d.ts                                                                           |                                                                                                                              |           |
| //vda1cs4850/node_modules/@types/dir/subdir/somefile.d.ts                                                                    |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/somefile.d.ts                                                                  |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                                       |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/somefile.d.ts                                                          |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/somefile.d.ts                                                      |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/node_modules/@types/dir/subdir/somefile.d.ts                                               |                                                                                                                              |           |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/somefile.d.ts                                                  | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/somefile.d.ts                                              | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/node_modules/@types/dir/subdir/somefile.d.ts                                       | //vda1cs4850/folderAtRoot/folder1/folder2/node_modules                                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/somefile.d.ts                                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/somefile.d.ts                                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules/@types/dir/subdir/somefile.d.ts                               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/node_modules                                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/somefile.d.ts                                  | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/somefile.d.ts                              | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types/dir/subdir/somefile.d.ts                       | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                                                       | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/somefile.d.ts                          | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/somefile.d.ts                      | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types/dir/subdir/somefile.d.ts               | //vda1cs4850/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                                               | true      |
| //vda1cs4850/users/node_modules/@types/somefile.d.ts                                                                         |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/somefile.d.ts                                                                     |                                                                                                                              |           |
| //vda1cs4850/users/node_modules/@types/dir/subdir/somefile.d.ts                                                              |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/somefile.d.ts                                                                |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/somefile.d.ts                                                            |                                                                                                                              |           |
| //vda1cs4850/users/username/node_modules/@types/dir/subdir/somefile.d.ts                                                     |                                                                                                                              |           |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/somefile.d.ts                                                   | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/somefile.d.ts                                               | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/node_modules/@types/dir/subdir/somefile.d.ts                                        | //vda1cs4850/users/username/folderAtRoot/node_modules                                                                        | true      |
| //vda1cs4850/users/username/folderAtRoot/folder1/node_modules/@types/som