// ----------------------------------------------------------------------------
// Copyright (C) 2014
//              David Freese, W1HKJ
//
// This file is part of fldigi
//
// fldigi is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// fldigi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
// ----------------------------------------------------------------------------

#include <config.h>

// This file contains pixmap versions of icons from the Tango Icon Library
// (version 0.8.90) at http://tango.freedesktop.org/Tango_Icon_Library
// which was released into the Public Domain.  This file was prepared by
// Kamal Mostafa <kamal@whence.com>, and is likewise released into the
// Public Domain.


// These #define's map the (new) Tango icon names (named after their source
// files) to the pixmap identifier names used throughout the fldigi source:

#define	tango_x_office_address_book	address_book_icon
#define	tango_applications_system	applications_system_icon
#define	tango_internet_group_chat	chat_icon
#define	tango_dialog_information	dialog_information_icon
#define	tango_edit_clear		edit_clear_icon
#define	tango_edit_copy			edit_copy_icon
#define	tango_edit_cut			edit_cut_icon
#define	tango_edit_paste		edit_paste_icon
#define	tango_edit_select_all		edit_select_all_icon
#define	tango_edit_undo			edit_undo_icon
#define	tango_emblem_system		emblems_system_icon
#define	tango_application_x_executable	executable_icon
#define	tango_document_open		file_open_icon
#define	tango_folder_open		folder_open_icon
#define	tango_help_browser		help_browser_icon
#define	tango_image_x_generic		image_icon
#define	tango_go_previous		left_arrow_icon
#define	tango_system_log_out		log_out_icon
#define	tango_list_remove		minus_icon
#define	tango_multimedia_player		multimedia_player_icon
#define	tango_internet_web_browser	net_icon
#define	tango_list_add			plus_icon
#define	tango_preferences_desktop_font	preferences_desktop_font_icon
#define	tango_process_stop		process_stop_icon
#define	tango_view_refresh		refresh_icon
#define	tango_go_next			right_arrow_icon
#define	tango_document_save_as		save_as_icon
#define	tango_document_save		save_icon
#define	tango_system_shutdown		shutdown_icon
#define	tango_start_here		start_here_icon
#define	tango_system_software_update	system_software_update_icon
#define	tango_system_users		system_users_icon
#define	tango_accessories_text_editor	text_editor_icon
#define	tango_text_x_generic		text_icon
#define	tango_x_office_calendar		time_icon
#define	tango_user_trash		trash_icon
#define	tango_utilities_system_monitor	utilities_system_monitor_icon
#define	tango_utilities_terminal	utilities_terminal_icon
#define	tango_weather_clear		weather_clear_icon
#define	tango48_dialog_information	dialog_information_48_icon
#define	tango48_dialog_warning		dialog_warning_48_icon

// ---------------------------------------------------------------------
// Tango icons
// ---------------------------------------------------------------------


/* mimetypes/x-office-address-book.png */
/* XPM */
const char *tango_x_office_address_book[] = {
/* width height ncolors chars_per_pixel */
"16 16 125 2",
/* colors */
"   c #000000",
" . c #C0D2E4",
" X c #ACC3DA",
" o c #A78AB1",
" O c #9DB029",
" + c #C3CFE0",
" @ c #9AA5C5",
" # c #D8E4F1",
" $ c #A7BFD8",
" % c #D7E4F0",
" & c #99A7C7",
" * c #A9B8D0",
" = c #D2DEEB",
" - c #ABB0BE",
" ; c #A887AE",
" : c #9CA2C3",
" > c #AC80A8",
" , c #CBD8E7",
" < c #A789B0",
" 1 c #617296",
" 2 c #AB82AA",
" 3 c #C3D0E2",
" 4 c #AA84AC",
" 5 c #B7CBE0",
" 6 c #A9B3CF",
" 7 c #8290AC",
" 8 c #7E8CA8",
" 9 c #ACB1BE",
" 0 c #95B1CF",
" q c #CEDBE9",
" w c #99A580",
" e c #7E8CAB",
" r c #AAACC9",
" t c #B5B5B6",
" y c #A491B6",
" u c #7B8AA8",
" i c #7A88A7",
" p c #9BA3C4",
" a c #727E0A",
" s c #DEDEDE",
" d c #AB92B6",
" f c #8F9FB8",
" g c #96AECC",
" h c #B1C0D6",
" j c #AA83AB",
" k c #A2AB7B",
" l c #FCE94F",
" z c #808DA9",
" x c #C7D7E8",
" c c #8F9E86",
" v c #95B0CE",
" b c #CC0000",
" n c #A5BDD7",
" m c #A8B8D0",
" M c #D1DEEB",
" N c #D0DCEA",
" B c #CFDCE9",
" V c #CEDAE8",
" C c #A8AEBC",
" Z c #A889AF",
" A c #AC80A9",
" S c #9BA2C3",
" D c #CFDCEC",
" F c #9DB7D2",
" G c #6F6384",
" H c #5A7AA4",
" J c #A78BB1",
" K c #67837F",
" L c #9AA4C5",
" P c #AFBAC9",
" I c #B9CBE0",
" U c #B4B9C4",
" Y c #9E9DBF",
" T c #BCC8D9",
" R c #828EAA",
" E c #95AFCD",
" W c #9FABC3",
" Q c #D7E3F0",
" ! c #D3DFEC",
" ~ c #A9B9D0",
" ^ c #9D9FC1",
" / c #B4C9DE",
" ( c #AFB5C2",
" ) c #ABB1BE",
" _ c #EDD400",
" ` c #C1C1C3",
" ' c #9CA1C3",
" ] c #698373",
" [ c #A7ADBD",
" { c #A9C1D9",
" } c #A8BFD8",
" | c #A9ACB8",
".  c #AA85AC",
".. c #9D9EC0",
".X c #B7CAE0",
".o c #818FAB",
".O c #808DAA",
".+ c #AC8BB1",
".@ c #A987AE",
".# c #8B96AE",
".$ c #CFDCEA",
".% c #6C7CA0",
".& c #785977",
".* c #A889B0",
".= c #AC82AA",
".- c #DDDDDD",
".; c #CCDAEA",
".: c #9AA6C6",
".> c #BACDE2",
"., c #B8CBE0",
".< c #9E9DC0",
".1 c #8390AC",
".2 c #EF2929",
".3 c #C6D6E7",
".4 c #95AFCE",
".5 c #A58DB3",
".6 c #A986AD",
".7 c #BFCCE0",
".8 c #A9B9D1",
".9 c #CFDBE9",
".0 c #B9B9B9",
".q c #CEDBE8",
".w c #B7B7B7",
".e c #CBD7E5",
".r c None",
/* pixels */
".r H H H H H H H H H H H H H.r.r",
" H.% =.3.> / n n $ $ } } F c _.r",
" H T N 3 D { L < A. .< 0 X c l _",
" H +.$ h.; 6 4 p.4 & ; S X w l _",
" H.e B m.; d ^ Y 2 j & o X k l _",
" H M.9 m.;.= g 4...6 E A X ] O a",
" H Q q *.; A E A '.@ : Z X ] O a",
" H #.q ~.;.+ L y.*.5 4.: X K O a",
" H #.q.8.; r ; & v 0 0 0 X G.2 b",
" H % V.7.; { @ J >.6 0 0 X G.2 b",
" H Q ! D x ..X 5 5.,.,., I G.2 b",
" H , e R z 8 i u.o 7.1.O 1.& b.r",
" H W t.w.w.w.w.w.w.w.0 P H H.r.r",
" H f `.-.-.-.-.- s s s U H H.r.r",
" H H.# [ ( - - ) ) 9 9 C | H.r.r",
".r H H H H H H H H H H H H H.r.r"
};


/* categories/applications-system.png */
/* XPM */
const char *tango_applications_system[] = {
/* width height ncolors chars_per_pixel */
"16 16 19 1",
/* colors */
"  c #000000",
". c #7CA1CF",
"X c #497CBA",
"o c #3F638F",
"O c #6490C7",
"+ c #467ABA",
"@ c #395578",
"# c #436FA5",
"$ c #BCCDE3",
"% c #5682B7",
"& c #86A7D2",
"* c #82A5D1",
"= c #4C7FBD",
"- c #426B9C",
"; c #5686C3",
": c #9DB8DA",
"> c #457ABE",
", c #8FAED5",
"< c None",
/* pixels */
"<<<<<<<<<<<<<<<<",
"<<<<<<>>><<<<<<<",
"<<<>><>$><>><<<<",
"<<>$&>O:O>&$><<<",
"<<>&:::::::&><<<",
"<<<>:.+;+*:><<<<",
"<>>O:+-<oX:O>><<",
"<>$::;<<<;::$><<",
"<>>O:=%<#+:O>><<",
"<<<>$.=;+,:><<<<",
"<<>&:::::::&><<<",
"<<>$&>O:O>&$><<<",
"<<<>><>$><>><<<<",
"<<<<<<>>><<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<"
};


/* apps/internet-group-chat.png */
/* XPM */
const char *tango_internet_group_chat[] = {
/* width height ncolors chars_per_pixel */
"16 16 23 1",
/* colors */
"  c #000000",
". c #9D9D9D",
"X c #F2F2F2",
"o c #F0F0F0",
"O c #EEEEEE",
"+ c #ECECEC",
"@ c #EAEAEA",
"# c #2D2D2D",
"$ c #767774",
"% c #888A85",
"& c #858682",
"* c #797A76",
"= c #C6C6C4",
"- c #FFFFFF",
"; c #F1F1F1",
": c #EFEFEF",
"> c #EDEDED",
", c #EBEBEB",
"< c #E9E9E9",
"1 c #343434",
"2 c #2A2A2A",
"3 c #868884",
"4 c None",
/* pixels */
"4444%%%%%%%%%%%4",
"444%-----------%",
"444%-,@<<<<<<<-%",
"4%%%%%%%%%%%=<-%",
"%-----------%<-%",
"%-<<<<<<<@,-%@-%",
"%-<<<<<@,++-%,-%",
"%-<<<<@,+>O-%--%",
"%-<<@,+>O::-%-%4",
"%-@,++>O:o;-%-%4",
"%-,+>O::o;X-%%%4",
"%--O:-------%4%4",
"4%-:-%%%%%%%.444",
"4%--%44444444444",
"4%%%444444444444",
"4%44444444444444"
};


/* status/dialog-information.png */
/* XPM */
const char *tango_dialog_information[] = {
/* width height ncolors chars_per_pixel */
"16 16 127 2",
/* colors */
"   c #000000",
" . c #394B7A",
" X c #E8EFF4",
" o c #4A577A",
" O c #CBD9E8",
" + c #40507A",
" @ c #E3E6BA",
" # c #F5F8FA",
" $ c #80805C",
" % c #C8D7E8",
" & c #C5D5E5",
" * c #3B4C78",
" = c #3A4A77",
" - c #D4E0ED",
" ; c #C1CCD7",
" : c #E0E9F2",
" > c #546083",
" , c #394A79",
" < c #EBF0F6",
" 1 c #475780",
" 2 c #EBEDC1",
" 3 c #46557F",
" 4 c #F7F9FB",
" 5 c #C5D2E1",
" 6 c #5988B9",
" 7 c #3D4D76",
" 8 c #D9E3EE",
" 9 c #495985",
" 0 c #595942",
" q c #B5C7DB",
" w c #586383",
" e c #9BAEC8",
" r c #A9C0D9",
" t c #3C4D78",
" y c #F3F7FA",
" u c #3B4B77",
" i c #5382B6",
" p c #D3DFEB",
" a c #EDEFF4",
" s c #E2EAF3",
" d c #393936",
" f c #5E8DBA",
" g c #F5F8CA",
" h c #A5BED8",
" j c #616471",
" k c #384977",
" l c #EEF3F8",
" z c #D0DDEB",
" x c #CEDBE9",
" c c #4F5873",
" v c #FAFCFD",
" b c #779DC5",
" n c #485883",
" m c #E8EFF5",
" M c #ABB198",
" N c #B5C6DA",
" B c #E2E7EF",
" V c #AAC1D9",
" C c #3E4E79",
" Z c #E0E5ED",
" A c #DDDFAB",
" S c #435177",
" D c #8C9BB8",
" F c #C3D3E4",
" G c #98A4BD",
" H c #B5CAE0",
" J c #D0D5E0",
" K c #DFE7F2",
" L c #DEE7F1",
" P c #91AECD",
" I c #384A79",
" U c #41517B",
" Y c #8A8B66",
" T c #E0E6EC",
" R c #5E5E3E",
" E c #B9C4D6",
" W c #5E6880",
" Q c #8D9CB8",
" ! c #3A4B77",
" ~ c #EFF3F7",
" ^ c #9AA5BE",
" / c #FCFCFD",
" ( c #A6AC98",
" ) c #789DC4",
" _ c #C1D2E4",
" ` c #F3F6C9",
" ' c #3A4B7A",
" ] c #C0D0E3",
" [ c #384978",
" { c #87A8CC",
" } c #ECF1F7",
" | c #4B7EB2",
".  c #45547E",
".. c #CCD9E8",
".X c #D3D5B0",
".o c #3D4C76",
".O c #D8E2ED",
".+ c #4A5A86",
".@ c #D4E0EC",
".# c #5281B5",
".$ c #7E90B2",
".% c #FFFFFF",
".& c #A7AD98",
".* c #608EBC",
".= c #C2D3E4",
".- c #464646",
".; c #4B5B83",
".: c #EBF0F5",
".> c #FAFBFD",
"., c #A4ADC3",
".< c #303030",
".1 c #C9D6E7",
".2 c #C7D6E5",
".3 c #F4F7FA",
".4 c #C2D0E0",
".5 c #D6E1ED",
".6 c #9DB9D6",
".7 c #7E91B1",
".8 c #B7C2D5",
".9 c #59627C",
".0 c #A6BED8",
".q c #A8AA84",
".w c #D2DAE2",
".e c #DFE8F2",
".r c #5C89BA",
".t c #5B89B9",
".y c None",
/* pixels */
".y.y.y.y.y u = [ I !.o.y.y.y.y.y",
".y.y.y.y *., a / 4 B ^ C.y.y.y.y",
".y.y.y t J # X s 8 p.O E U.y.y.y",
".y.y 7., # ~.3 <.e -.= & Q S.y.y",
".y.y + a m y v } K z _ ) 5 3.y.y",
".y.y ,.> : l.%.%.%.% ;.y x ..y.y",
".y.y '.3.5 L.%.: T.w P.y.1 ..y.y",
".y.y.  Z O %.% ] H.6.y.* q n.y.y",
".y.y o G.@.0.% h {.y | V.7 >.y.y",
".y.y.y 1.8 F b.%.y f r e 9.y.y.y",
".y.y.y.y 1 D.4...2 N.$.+.y.y.y.y",
".y.y.y.y.y w.; (.& M W.y.y.y.y.y",
".y.y.y.y.y.y R 2 g A R.y.y.y.y.y",
".y.y.y.y.y.y R $.q Y R.y.y.y.y.y",
".y.y.y.y.y.y R @ `.X R.y.y.y.y.y",
".y.y.y.y.y.y.y d.-.<.y.y.y.y.y.y"
};


/* actions/edit-clear.png */
/* XPM */
const char *tango_edit_clear[] = {
/* width height ncolors chars_per_pixel */
"16 16 113 2",
/* colors */
"   c #E7D75B",
" . c #EED723",
" X c #AB1B0D",
" o c #C86D33",
" O c #BBA529",
" + c #FDEC6D",
" @ c #C5B536",
" # c #DCC407",
" $ c #EDDA46",
" % c #A08E01",
" & c #9F8E00",
" * c #CDBD41",
" = c #E8DA6C",
" - c #D7B162",
" ; c #E6D656",
" : c #E1D35B",
" > c #CCBD43",
" , c #FDE952",
" < c #E7D018",
" 1 c #9C8800",
" 2 c #C6B633",
" 3 c #C5B432",
" 4 c #BC7A0F",
" 5 c #FDEA5F",
" 6 c #CFC149",
" 7 c #A29009",
" 8 c #A19008",
" 9 c #FDEB6C",
" 0 c #D2C34F",
" q c #DCC610",
" w c #AE9E1B",
" e c #F8EA88",
" r c #AB6D0B",
" t c #C17D10",
" y c #F3E365",
" u c #B2760B",
" i c #9E8D01",
" p c #E4D249",
" a c #ECDC68",
" s c #E7D96D",
" d c #BB4A28",
" f c #9F8F05",
" g c #F6D861",
" h c #9A8500",
" j c #FDEC6B",
" k c #FDEB61",
" l c #EBDD77",
" z c #804E01",
" x c #DAC203",
" c c #9F8E01",
" v c #AB9B1A",
" b c #E2D467",
" n c #9F8E04",
" m c #EADC72",
" M c #A12400",
" N c #B8381D",
" B c #876400",
" V c #FDEA63",
" C c #DDCF5E",
" Z c #FDEF84",
" A c #A08F01",
" S c #9F8D00",
" D c #D8C84F",
" F c #E3CB11",
" G c #A96B0A",
" H c #C6B530",
" J c #BEAE32",
" K c #FDEE7D",
" L c #B2720C",
" P c #9C8B00",
" I c #9C7F00",
" U c #A6690A",
" Y c #FDEF8A",
" T c #E5D44E",
" R c #B06917",
" E c #F3DB2A",
" W c #DCC510",
" Q c #FBED8B",
" ! c #A18801",
" ~ c #D6C856",
" ^ c #7B4A00",
" / c #FBEA84",
" ( c #FFFFFF",
" ) c #9D8C00",
" _ c #FCE53C",
" ` c #A03600",
" ' c #E4D34C",
" ] c #DCCD58",
" [ c #DFCA26",
" { c #784800",
" } c #EBDE77",
" | c #B1A01D",
".  c #C0B02F",
".. c #DBC304",
".X c #F6DE2F",
".o c #AD4213",
".O c #E7D85F",
".+ c #A59411",
".@ c #FBE437",
".# c #7C4B00",
".$ c #9F8D01",
".% c #9E8D00",
".& c #E5CD14",
".* c #FBE544",
".= c #DCC615",
".- c #FDE63C",
".; c #865203",
".: c #845201",
".> c #A08F05",
"., c #CDBE45",
".< c #794900",
".1 c #8A6900",
".2 c None",
/* pixels */
".2.# ^.2.2.2.2.2.2.2.2.2.2.2.2.2",
" ^ U r ^.2.2.2.2.2.2.2.2.2.2.2.2",
" ^ L t G ^.2 P.2.2.2.2.2.2.2.2.2",
".2.; 4 t.: h P.2.2.2.2.2.2.2.2.2",
".2 ^ z u ! J |.2.2.2.2.2.2.2.2.2",
".2.2 B 1 * } R ` A.2.2.2.2.2.2.2",
".2.2 i D a o X - m > 7 c.2.2.2.2",
".2.2.% O d N g V 9 K e., f &.2.2",
".2.2.2 M.o / j Z + ,.* y l 6 w )",
".2.2.2.2.  Y 5 k ,.- E < q p b.$",
".2.2.2.2.+ Q _.@.X ..&.. x ; 2 &",
".2.2.2.2 % C $ < F # x x ' ] n.2",
".2.2.2.2.2 v = W x x.=   ~.>.2.2",
".2.2.2.2.2 & @.O [ T s 3.%.2.2.2",
".2.2.2.2.2.2.% 0 : H 8 S.2.2.2.2",
".2.2.2.2.2.2.2 ).%.%.2.2.2.2.2.2"
};


/* actions/edit-copy.png */
/* XPM */
const char *tango_edit_copy[] = {
/* width height ncolors chars_per_pixel */
"16 16 44 1",
/* colors */
"  c #000000",
". c #E3E4E2",
"X c #9A9B97",
"o c #8D8F8A",
"O c #898B86",
"+ c #C8C8C7",
"@ c #C6C6C5",
"# c #C4C4C3",
"$ c #8F908B",
"% c #FEFEFE",
"& c #FAFAFA",
"* c #F4F4F4",
"= c #F2F2F2",
"- c #EEEEEE",
"; c #ECECEC",
": c #EAEAEA",
"> c #8E9189",
", c #D4D4D4",
"< c #C3C4C3",
"1 c #F7F7F6",
"2 c #F3F3F2",
"3 c #EFEFEE",
"4 c #EDEDEC",
"5 c #E3E3E2",
"6 c #989A95",
"7 c #8C8E89",
"8 c #8A8C87",
"9 c #888A85",
"0 c #C7C7C6",
"q c #FFFFFF",
"w c #FBFBFB",
"e c #F9F9F9",
"r c #F3F3F3",
"t c #EBEBEB",
"y c #989A96",
"u c #FEFEFD",
"i c #FCFCFB",
"p c #FAFAF9",
"a c #F8F8F7",
"s c #F6F6F5",
"d c #F4F4F3",
"f c #F0F0EF",
"g c #EEEEED",
"h c None",
/* pixels */
"hhhhhhhhhhhhhhhh",
"hhhhhhhhhhhhhhhh",
"hhhhhhhhhhhhhhhh",
"hhhhX9999999999o",
"hhhh8qqqqqqqqqq9",
"hhhhOqffffffffq9",
"hhhh8qf000000fq9",
"hhhhOqffffffffq9",
"hhhh8qf00000ffq9",
"hhhhOqfffffff&r9",
"hhhh8qf00000-1<9",
"hhhh8qfffff77779",
"hhhhOuffff&6&a.9",
"hhhhOpfff&&6&599",
"hhhhO*1siw,y.9hh",
"hhhh7O9999999hhh"
};


/* actions/edit-cut.png */
/* XPM */
const char *tango_edit_cut[] = {
/* width height ncolors chars_per_pixel */
"16 16 94 2",
/* colors */
"   c #000000",
" . c #AA0909",
" X c #A80707",
" o c #959792",
" O c #939590",
" + c #91938E",
" @ c #AB0D0D",
" # c #90918D",
" $ c #8F918C",
" % c #A90B0B",
" & c #8D8F8A",
" * c #8B8D88",
" = c #CB1F1F",
" - c #9C2F2C",
" ; c #B3B2AF",
" : c #C01514",
" > c #A80403",
" , c #A70202",
" < c #AB1313",
" 1 c #AA0808",
" 2 c #A80606",
" 3 c #E1E1DF",
" 4 c #AE1919",
" 5 c #B70F0E",
" 6 c #CE1E1E",
" 7 c #A90A0A",
" 8 c #D2D3D0",
" 9 c #AA0E0E",
" 0 c #DB2727",
" q c #F5F6F5",
" w c #AE1818",
" e c #EFF0EF",
" r c #D01F1F",
" t c #CE1D1D",
" y c #CD1D1C",
" u c #898984",
" i c #CCCEC9",
" p c #C6C8C3",
" a c #AA0D0D",
" s c #B8BAB5",
" d c #AB1111",
" f c #B6B8B3",
" g c #B5B6B2",
" h c #F7F7F6",
" j c #D42222",
" k c #AAACA7",
" l c #A60202",
" z c #D22020",
" x c #B80D0D",
" c c #9FA09C",
" v c #A70606",
" b c #9A9C97",
" n c #92948F",
" m c #C91A1A",
" M c #AA0C0C",
" N c #8E908B",
" B c #8C8E89",
" V c #8A8C87",
" C c #AB1010",
" Z c #D62323",
" A c #A80303",
" S c #A60101",
" D c #A90707",
" F c #AF1A1A",
" G c #A40502",
" H c #AB1616",
" J c #DBDCD9",
" K c #CD1D1D",
" L c #CA1B1A",
" P c #AA0B0B",
" I c #D2D4D0",
" U c #CDCECB",
" Y c #C5C6C3",
" T c #C01513",
" R c #B5B6B3",
" E c #F7F7F7",
" W c #AD1717",
" Q c #D12020",
" ! c #A34A45",
" ~ c #B50B0B",
" ^ c #A60606",
" / c #A00A00",
" ( c #C71A19",
" ) c #BABBB7",
" _ c #B3B5B0",
" ` c #AEAFAB",
" ' c #D52323",
" ] c #D32121",
" [ c #A8A9A5",
" { c #D11F1F",
" } c #AB1414",
" | c #CF1D1D",
".  c #E7E8E6",
".. c None",
/* pixels */
"........ * O........ * $........",
"...... N E *........ # 8 $......",
"...... * I e n...... k p &......",
"...... & _ h *.... N i ` *......",
"........ * J e + B f U *........",
"........ & g E * c R s *........",
".......... * 3 q b [ *..........",
".......... & ).  k N V..........",
"............ u Y ; -............",
"........ w H ^ ! l ( W w........",
"...... D z 6 5 G > m Q = 7......",
".... 2 r A : S.... y T A K v....",
".. } '.... t 7.... A L.... Q }..",
".. @ |.. ~ ] M.... . Z x.. { d..",
".. < 0 r t X........ 1 j | t <..",
".... 9 C H............ a P %...."
};


/* actions/edit-paste.png */
/* XPM */
const char *tango_edit_paste[] = {
/* width height ncolors chars_per_pixel */
"16 16 79 1",
/* colors */
"  c #000000",
". c #6A6C68",
"X c #666864",
"o c #C68827",
"O c #6E4602",
"+ c #6D4401",
"@ c #C08424",
"# c #7F7F7C",
"$ c #EFEFED",
"% c #EDEDEB",
"& c #EBEBE9",
"* c #E9E9E7",
"= c #E7E7E5",
"- c #676964",
"; c #DBDBD9",
": c #B2B4B4",
"> c #6E6C64",
", c #CCCDCA",
"< c #6B4301",
"1 c #FEFEFE",
"2 c #F2F2F2",
"3 c #EDEEED",
"4 c #BA7F23",
"5 c #D8D8D5",
"6 c #E0E0E0",
"7 c #A77D3B",
"8 c #5C5C5B",
"9 c #6C4401",
"0 c #C1C2BE",
"q c #B9BAB6",
"w c #6B4403",
"e c #B37B22",
"r c #EFEFEE",
"t c #EDEDEC",
"y c #EBEBEA",
"u c #C58726",
"i c #97978A",
"p c #6E4502",
"a c #80807D",
"s c #7E7E7B",
"d c #ECECEA",
"f c #EAEAE8",
"g c #716F64",
"h c #E8E8E6",
"j c #706D63",
"k c #DADAD8",
"l c #6F4602",
"z c #B97F23",
"x c #B3B5B5",
"c c #6E6D64",
"v c #CDCECB",
"b c #A17C40",
"n c #5E5E5E",
"m c #5C5C5C",
"M c #6A4200",
"N c #C28628",
"B c #FFFFFF",
"V c #E7E7E4",
"C c #F1F1F1",
"Z c #D9D9D6",
"A c #B1B2B2",
"S c #C58727",
"D c #5F5F5E",
"F c #959589",
"G c #6C4301",
"H c #6B4300",
"J c #B9B9B6",
"K c #B8B9B5",
"L c #FEFEFD",
"P c #B7B7B4",
"I c #736F64",
"U c #BBBBBB",
"Y c #F0F0EF",
"T c #EEEEED",
"R c #A47E3E",
"E c #A37C3D",
"W c #ECECEB",
"Q c #706D64",
"! c None",
/* pixels */
"!!!!!DmmmmD!!!!!",
"!!+9w8FiiF8w99!!",
"!+@RQn#aasn>bzG!",
"!logC6UUUU62cSM!",
"!loXBYYYYYYB-NM!",
"!luXBYxxxxrB-NM!",
"!luXBYYYY$%B-NM!",
"!OuXBYxx:AfB-NM!",
"!OuXBYrtyf;B-NM!",
"!OuXBTW&*k,B-NM!",
"!OuXBdfhvqKB-NM!",
"!puXB*=ZJBBB-NM!",
"!puXBV50PBB-SNM!",
"!puj3111rL-SSSM!",
"!G47I.....EEEe<!",
"!!G9999999999<!!"
};


/* actions/edit-select-all.png */
/* XPM */
const char *tango_edit_select_all[] = {
/* width height ncolors chars_per_pixel */
"16 16 38 1",
/* colors */
"  c #000000",
". c #B3C9E1",
"X c #B1C7DF",
"o c #AFC5DD",
"O c #ADC3DB",
"+ c #ABC1D9",
"@ c #8D8F8A",
"# c #A9BFD7",
"$ c #8B8D88",
"% c #8197AF",
"& c #FEFEFE",
"* c #FCFCFC",
"= c #FAFAFA",
"- c #F8F8F8",
"; c #F6F6F6",
": c #F4F4F4",
"> c #F2F2F2",
", c #F0F0F0",
"< c #EEEEEE",
"1 c #ECECEC",
"2 c #8B8D89",
"3 c #B2C8E0",
"4 c #B0C6DE",
"5 c #AEC4DC",
"6 c #ACC2DA",
"7 c #AAC0D8",
"8 c #8C8E89",
"9 c #A8BED6",
"0 c #888A85",
"q c #8298B0",
"w c #FFFFFF",
"e c #FDFDFD",
"r c #FBFBFB",
"t c #F9F9F9",
"y c #F7F7F7",
"u c #F5F5F5",
"i c #EBEBEB",
"p c None",
/* pixels */
"p20000000000008p",
"p0e&&ee**rr==t$p",
"p0e9##77+++++-$p",
"p0&#%%%%6%%%6-$p",
"p0e7%%%%OOOOO-$p",
"p0e7%%%%O555i-$p",
"p0*+%%%%5%%o1-$p",
"p0*66O5oo444<-$p",
"p0*6O5oo44XX,-$p",
"p0r6%%%%%%%3>y$p",
"p0rO5o44 3 .:y$p",
"p0=O5o4X3 u;;y$p",
"p0tOqqqq3 y-yy$p",
"p0tO5o4X3 yt-y$p",
"p0------ - ---$p",
"p8000000000000@p"
};


/* actions/edit-undo.png */
/* XPM */
const char *tango_edit_undo[] = {
/* width height ncolors chars_per_pixel */
"16 16 70 1",
/* colors */
"  c #000000",
". c #F3E56A",
"X c #F4DF2C",
"o c #F1DB29",
"O c #F9EA69",
"+ c #DFC80A",
"@ c #BB9F15",
"# c #F6E131",
"$ c #EBDC6F",
"% c #C4A000",
"& c #EFE276",
"* c #D6C004",
"= c #C19E00",
"- c #BBA11B",
"; c #EEE16E",
": c #FAEC73",
"> c #BCA015",
", c #F8E232",
"< c #DAC304",
"1 c #F5E02F",
"2 c #C1A313",
"3 c #7D7905",
"4 c #FAEB6F",
"5 c #DFC90F",
"6 c #BEA113",
"7 c #ECD936",
"8 c #E3CD16",
"9 c #BF9D00",
"0 c #C1A319",
"q c #DBC443",
"w c #C8AC02",
"e c #BCA114",
"r c #F7DD05",
"t c #FBED76",
"y c #DFC80B",
"u c #FBED79",
"i c #B99900",
"p c #7C7A06",
"a c #D8C207",
"s c #E9DA5D",
"d c #CBAA0E",
"f c #F7E86E",
"g c #F2E469",
"h c #E8D21D",
"j c #C0A41A",
"k c #F7E232",
"l c #FBF3AD",
"z c #C1A314",
"x c #F6E769",
"c c #FBE425",
"v c #C5AB1B",
"b c #C4A71A",
"n c #C0A623",
"m c #E1CD40",
"M c #C2A611",
"N c #BDA116",
"B c #C2A211",
"V c #FAE320",
"C c #BFA31B",
"Z c #EADB66",
"A c #C3A618",
"S c #F7E86C",
"D c #F2E788",
"F c #E3CE41",
"G c #F5E66D",
"H c #F6E02F",
"J c #D8C543",
"K c #7E7905",
"L c #C4A901",
"P c None",
/* pixels */
"PPPPPP%PPPPPPPPP",
"PPPPP%%PPPPPPPPP",
"PPPP%l%PPPPPPPPP",
"PPP%lc%%6@-PPPPP",
"PP%l#V:4fSezPPPP",
"P%lHko1o87xF2PPP",
"%lH,kk1ohhh7mNPP",
"P%u,X***hhhy.v>P",
"PP%t<tOOOOr+a$CP",
"PPP%tt%%%%L;5gjP",
"PPPP%t%PPPP%G&0P",
"PPPPP%%PPPPPwDBP",
"PPPPPP%PPPPPdsnP",
"PPPPPPPPPPPPqJPP",
"PPPPPPPPPPPPZMPP",
"PPPPPPPPPPPPPPPP"
};


/* emblems/emblem-system.png */
/* XPM */
const char *tango_emblem_system[] = {
/* width height ncolors chars_per_pixel */
"16 16 19 1",
/* colors */
"  c #000000",
". c #C7CAC3",
"X c #8F918C",
"o c #8D8F8A",
"O c #B8BAB4",
"+ c #888A84",
"@ c #A2A3A0",
"# c #898B87",
"$ c #777975",
"% c #71736F",
"& c #D3D7CF",
"* c #676965",
"= c #555753",
"- c #888A85",
"; c #BDBFB9",
": c #EEEEEC",
"> c #979993",
", c #C0C0BE",
"< c None",
/* pixels */
"<<<<<<<<<<<<<<<<",
"<<<<<<---<<<<<<<",
"<<<--<-:-<--<<<<",
"<<-:,-@&@-,:-<<<",
"<<-,&&&&&&&,-<<<",
"<<<-&O+>+;&-<<<<",
"<--@&+%<*#&@--<<",
"<-:&&><<<>&&:-<<",
"<--@&oX<$+&@--<<",
"<<<-:Oo>+.&-<<<<",
"<<-,&&&&&&&,-<<<",
"<<-:,-@&@-,:-<<<",
"<<<--<-:-<--<<<<",
"<<<<<<---<<<<<<<",
"<<<<<<<<<<<<<<<<",
"<<<<<<<<<<<<<<<<"
};


/* mimetypes/application-x-executable.png */
/* XPM */
const char *tango_application_x_executable[] = {
/* width height ncolors chars_per_pixel */
"16 16 70 1",
/* colors */
"  c #000000",
". c #9BABC3",
"X c #8790B6",
"o c #ADB8CE",
"O c #ABB6CC",
"+ c #5F7A9F",
"@ c #7F90B1",
"# c #A5B2C9",
"$ c #A4B2C8",
"% c #9197BC",
"& c #9FAEC6",
"* c #8991B7",
"= c #AFB9CF",
"- c #AEB9CE",
"; c #BFC4D8",
": c #7382AB",
"> c #95A2BF",
", c #949ABE",
"< c #7D89B1",
"1 c #7C89B0",
"2 c #8D9EBA",
"3 c #8E9CBB",
"4 c #A0AFC6",
"5 c #B0BACF",
"6 c #9D9FC3",
"7 c #C1C5D9",
"8 c #7483AB",
"9 c #99A3C2",
"0 c #858EB5",
"q c #AAB6CC",
"w c #8F9BBB",
"e c #9099BC",
"r c #A2AEC7",
"t c #A1AAC6",
"y c #7786AD",
"u c #8895B7",
"i c #ACB7CD",
"p c #7182AA",
"a c #566F99",
"s c #7A87AF",
"d c #ACB0CC",
"f c #8394B4",
"g c #A8B4CB",
"h c #A7B4CA",
"j c #A7B2CA",
"k c #50688F",
"l c #A5B0C8",
"z c #C8CADD",
"x c #546C96",
"c c #7C8EB0",
"v c #7C8CB0",
"b c #7B88AF",
"n c #8D9FBA",
"m c #7A88AE",
"M c #B2BBD1",
"N c #B1BBD0",
"B c #516A96",
"V c #7584AC",
"C c #364878",
"Z c #858FB5",
"A c #98A2C1",
"S c #ABB5CD",
"D c #A9B5CB",
"F c #A9B3CB",
"G c #A7B1C9",
"H c #486490",
"J c #A3B1C8",
"K c #B3BCD1",
"L c #C3C7DA",
"P c None",
/* pixels */
"PPPPPPPCPPPPPPPP",
"PPPPPPCLCPPPPPPP",
"PPPPPCL.+CPPPPPP",
"PPPPCL&4nHCPPPPP",
"PPPCLJ$#2BaCPPPP",
"PPCLhgDqcf@aCPPP",
"PCLOio-rv>FpaCPP",
"CL=5NMj3SKy:VaCP",
"PCLGlwu8t9b<aCPP",
"PPCLms1A;eZaCPPP",
"PPPCL0X*7,aCPPPP",
"PPPPCL%dzaCPPPPP",
"PPPPPCL6aCPPPPPP",
"PPPPPPCaCPPPPPPP",
"PPPPPPPCPPPPPPPP",
"PPPPPPPPPPPPPPPP"
};


/* actions/document-open.png */
/* XPM */
const char *tango_document_open[] = {
/* width height ncolors chars_per_pixel */
"16 16 139 2",
/* colors */
"   c #85ABD5",
" . c #7E8896",
" X c #406CA5",
" o c #A9A9A9",
" O c #3767A6",
" + c #A5A5A5",
" @ c #3565A4",
" # c #C3D6EA",
" $ c #A2A3A2",
" % c #5B5C59",
" & c #A1A1A1",
" * c #5A5C58",
" = c #565854",
" - c #9C9D9C",
" ; c #9B9B9B",
" : c #999999",
" > c #969796",
" , c #BFD2E9",
" < c #7EA7D4",
" 1 c #98B9DD",
" 2 c #BBD2E8",
" 3 c #797979",
" 4 c #737373",
" 5 c #3768A5",
" 6 c #3666A4",
" 7 c #C5D7EB",
" 8 c #5689C0",
" 9 c #85ACD7",
" 0 c #9FA09E",
" q c #656565",
" w c #5F5F5F",
" e c #C1D5EA",
" r c #5B5B5B",
" t c #555555",
" y c #7FA8D4",
" u c #515151",
" i c #FEFEFE",
" p c #FCFCFC",
" a c #8AAFD8",
" s c #494949",
" d c #FAFAFA",
" f c #95B8DC",
" g c #EAEAEA",
" h c #E8E8E8",
" j c #E6E6E6",
" k c #E2E2E2",
" l c #E0E0E0",
" z c #DEDEDE",
" x c #77A2D2",
" c c #DCDCDC",
" v c #3667A6",
" b c #DADADA",
" n c #3465A4",
" m c #5B5E5A",
" M c #D2D2D2",
" N c #81A9D5",
" B c #D0D0D0",
" V c #4B7EB7",
" C c #3265A5",
" Z c #8BB0D8",
" A c #C4C4C4",
" S c #96B7DC",
" D c #3968A5",
" F c #B0B0B0",
" G c #B9D0E7",
" H c #AEAEAE",
" J c #ACACAC",
" K c #AAAAAA",
" L c #79A3D3",
" P c #92B5DB",
" I c #A6A6A6",
" U c #5F615D",
" Y c #3666A5",
" T c #3566A4",
" R c #5D5F5B",
" E c #5B5D59",
" W c #595B57",
" Q c #D5D5D4",
" ! c #575955",
" ~ c #83AAD6",
" ^ c #82AAD5",
" / c #555753",
" ( c #9BBADD",
" ) c #C0D5EA",
" _ c #C1C1C0",
" ` c #7A7A7A",
" ' c #787878",
" ] c #3767A5",
" [ c #A5A5A4",
" { c #6E6E6E",
" } c #5B5C58",
" | c #5588BF",
".  c #6A6A6A",
".. c #9C9D9B",
".X c #3567A6",
".o c #8FB2DA",
".O c #8EB2D9",
".+ c #939392",
".@ c #3465A5",
".# c #C1D6EA",
".$ c #565656",
".% c #B1C9E4",
".& c #4C4C4C",
".* c #FDFDFD",
".= c #FBFBFB",
".- c #484848",
".; c #F9F9F9",
".: c #F7F7F7",
".> c #7BA5D3",
"., c #95B7DC",
".< c #94B5DB",
".1 c #3868A5",
".2 c #EBEBEB",
".3 c #E9E9E9",
".4 c #E7E7E7",
".5 c #E5E5E5",
".6 c #E3E3E3",
".7 c #B8CEE7",
".8 c #DFDFDF",
".9 c #DDDDDD",
".0 c #3566A5",
".q c #3466A4",
".w c #D9D9D9",
".e c #D3D3D3",
".r c #D0D1D0",
".t c #9ABADD",
".y c #CFCFCF",
".u c #CDCDCD",
".i c #C9C9C9",
".p c #C7C7C7",
".a c #C5C5C5",
".s c #A5C1E1",
".d c #7DA6D4",
".f c #BDBDBD",
".g c #95B6DB",
".h c #B7B7B7",
".j c #454A51",
".k c #B3B3B3",
".l c None",
/* pixels */
".l.l.l.l = ! = ! ! W * U.l.l.l.l",
" ` 3 3 3 =.:.; d.=.= p $ }.l.l.l",
" '.i.p A / b.e.e M.y.u i.+ m.l.l",
" 4.a F J / c - - - - Q i.* > E.l",
" { _ J K = k.8 z z.9 l.3.5 B R.l",
". .f o + = j 0.......9.6.6.r E.l",
" q.h I & !.2 g g.3.3 h h.4.w %.l",
" w.k X.1.1 5 Y Y.0 T T T n n n O",
" r H.0 ) ) ) ) ) ) e.#.#.#.# 2.@",
".$ o T # P P P P P P P P P f G.q",
" u [ 6 7 1 1 1 1 1 1 1 1 1.,.7.0",
".& & ] , (.t.t.t.t.t.t S.o Z.%.0",
".- ;.1.s.O a 9 ~ N < L x x.>.g.X",
" s : D.< ^.d.d.d.d.d.d.d.d y   Y",
".- . D | 8 8 8 8 8 8 8 8 8 8 V v",
".j n n n n n n n n n n n n n @.l"
};


/* status/folder-open.png */
/* XPM */
const char *tango_folder_open[] = {
/* width height ncolors chars_per_pixel */
"16 16 123 2",
/* colors */
"   c #000000",
" . c #ADADAD",
" X c #ABABAB",
" o c #A9A9A9",
" O c #92B6DB",
" + c #92B4DB",
" @ c #A7A7A7",
" # c #3667A5",
" $ c #A5A5A5",
" % c #A3A3A3",
" & c #A1A1A1",
" * c #9F9F9F",
" = c #9DBDDF",
" - c #9D9D9D",
" ; c #9B9B9B",
" : c #B5CDE6",
" > c #999999",
" , c #7EA7D4",
" < c #3968A4",
" 1 c #484849",
" 2 c #797979",
" 3 c #757575",
" 4 c #94B7DC",
" 5 c #737373",
" 6 c #93B5DB",
" 7 c #6D6D6D",
" 8 c #86AED8",
" 9 c #6B6B6B",
" 0 c #B7CEE7",
" q c #656565",
" w c #5F5F5F",
" e c #C1D5EA",
" r c #5B5B5B",
" t c #7FA8D4",
" y c #515151",
" u c #B1CAE4",
" i c #4779B4",
" p c #494949",
" a c #A2BFDF",
" s c #86ABD4",
" d c #95B8DC",
" f c #AEC8E4",
" g c #4971A5",
" h c #B8CFE7",
" j c #3567A5",
" k c #4F79AE",
" l c #3465A4",
" z c #81A9D5",
" x c #9BBBDE",
" c c #3C6AA5",
" v c #CACACA",
" b c #C8C8C8",
" n c #8CB0D9",
" m c #C4C4C4",
" M c #C0C0C0",
" N c #BABABA",
" B c #3968A5",
" V c #3766A3",
" C c #88AED8",
" Z c #B2B2B2",
" A c #B0B0B0",
" S c #AEAEAE",
" D c #ACACAC",
" F c #AAAAAA",
" G c #92B5DB",
" H c #3868A7",
" J c #A6A6A6",
" K c #3666A5",
" L c #A4A4A4",
" P c #C4D7EB",
" I c #A0A0A0",
" U c #9E9E9E",
" Y c #82AAD5",
" T c #9C9C9C",
" R c #9A9A9A",
" E c #406DA8",
" W c #6A7F99",
" Q c #8EB3DA",
" ! c #C1C1C0",
" ~ c #808080",
" ^ c #7A7A7A",
" / c #787878",
" ( c #454F5D",
" ) c #747474",
" _ c #94B6DC",
" ` c #93B6DB",
" ' c #A5A5A4",
" ] c #598CC3",
" [ c #6E6E6E",
" { c #3463A2",
" } c #6C6C6C",
" | c #6A6A6A",
".  c #84ABD6",
".. c #B7CFE7",
".X c #606060",
".o c #608FC3",
".O c #3465A5",
".+ c #565656",
".@ c #B3CBE6",
".# c #8F949B",
".$ c #FFFFFF",
".% c #4C4C4C",
".& c #8BB0D9",
".* c #484848",
".= c #688FBD",
".- c #3868A5",
".; c #85ACD6",
".: c #B7CEE6",
".> c #68809F",
"., c #91B5DB",
".< c #3768A7",
".1 c #3566A5",
".2 c #B4CCE6",
".3 c #C9C9C9",
".4 c #8DB1DA",
".5 c #C7C7C7",
".6 c #C5C5C5",
".7 c #BED3E9",
".8 c #BDBDBD",
".9 c #5C8EC4",
".0 c #B7B7B7",
".q c #B3B3B3",
".w c None",
/* pixels */
".w.w.w.w.w.w.w.w.w.w.w.w.w.w.w.w",
" ^ 2 2 2 2 2 2.w.w.w.w.w.w.w.w.w",
" /.3.5.6 m m Z 3.w.w.w.w.w.w.w.w",
" 5.6 A . X F F ^ 7 } 9 9 | [.w.w",
" [ ! D F @ $ L o N.6 b v M q.w.w",
" |.8 o J % & I * * I & % % w.w.w",
" q.0 J % I - T ; R ; T U U r.w.w",
" w.q % g B B B B B B B B B V K.<",
" r S I.-.2 0 0...:.:.:.:.:.: u.O",
".+ o U <.7 O., G O O O O ` d.@.1",
" y ' T c e 4 4 4 4 4 4 4 Q 8 :.1",
".% & ; E P x x x x x _.& C.4 h.1",
".* ;.# k f 6 + n.; t , , , Y a #",
" p >.>.= =.& Y z z z z z z.  s H",
" 1 W B.o.9 ] ] ] ] ] ] ] ] ] i j",
" ( l l l l l l l l l l l l l l.w"
};


/* apps/help-browser.png */
/* XPM */
const char *tango_help_browser[] = {
/* width height ncolors chars_per_pixel */
"16 16 153 2",
/* colors */
"   c #7497C1",
" . c #D6DEE9",
" X c #466DA1",
" o c #8BA5C7",
" O c #2F5891",
" + c #E6EBF2",
" @ c #E4E9F0",
" # c #4B6E9F",
" $ c #8CA2C1",
" % c #6B8FBB",
" & c #567CAD",
" * c #5278A9",
" = c #829DC1",
" - c #AABAD1",
" ; c #EDF0F5",
" : c #FDFDFE",
" > c #6387B6",
" , c #4B72A5",
" < c #345D95",
" 1 c #6482AD",
" 2 c #335B94",
" 3 c #617EAA",
" 4 c #BAC9DD",
" 5 c #CDDAE9",
" 6 c #E8ECF3",
" 7 c #2E558F",
" 8 c #2D558E",
" 9 c #E6EAF1",
" 0 c #C8D4E4",
" q c #7296C1",
" w c #C2CEDE",
" e c #4D6FA0",
" r c #A0B9D7",
" t c #5A7FB0",
" y c #728FB7",
" u c #5B7AA7",
" i c #2A538E",
" p c #7999C1",
" a c #F2F5F9",
" s c #F0F3F7",
" d c #365C93",
" f c #BDCADC",
" g c #FEFEFE",
" h c #597AA8",
" j c #6D8BB5",
" k c #6B89B3",
" l c #6987B1",
" z c #6286B4",
" x c #4D73A6",
" c c #386098",
" v c #214B88",
" b c #6381AB",
" n c #EDF1F7",
" m c #315891",
" M c #E9EDF3",
" N c #6C8DB7",
" B c #2D5690",
" V c #86A1C3",
" C c #5C7BA7",
" Z c #9BB2D1",
" A c #C9D7E7",
" S c #6C88B0",
" D c #6587B3",
" F c #BDC9DB",
" G c #547AAC",
" H c #3B639A",
" J c #6B88B2",
" K c #244E8A",
" L c #234C89",
" P c #224C88",
" I c #8FA8C8",
" U c #6582AC",
" Y c #CBD6E5",
" T c #6085B4",
" R c #94A9C6",
" E c #5E83B2",
" W c #325B94",
" Q c #E5EAF1",
" ! c #3B6096",
" ~ c #C0CCDD",
" ^ c #8CA1C1",
" / c #6A8EBA",
" ( c #5978A6",
" ) c #5878A5",
" _ c #3C649A",
" ` c #264F8B",
" ' c #254F8A",
" ] c #94ADCC",
" [ c #6284B2",
" { c #F1F5F9",
" } c #F0F3F8",
" | c #EFF3F7",
".  c #A9B9D0",
".. c #496FA3",
".X c #345C95",
".o c #335C94",
".O c #E8EDF3",
".+ c #B7C6DA",
".@ c #E7EBF2",
".# c #2C548D",
".$ c #A6B9D3",
".% c #7093BF",
".& c #42699F",
".* c #40679D",
".= c #5176A7",
".- c #27508B",
".; c #6A86AF",
".: c #ADBCD3",
".> c #F1F4F8",
"., c #7594BD",
".< c #EFF2F6",
".1 c #A0B5D0",
".2 c #FFFFFF",
".3 c #678BB9",
".4 c #9BAFCB",
".5 c #6589B7",
".6 c #4C72A5",
".7 c #204A87",
".8 c #6482AC",
".9 c #A7B8D0",
".0 c #E9EEF3",
".q c #2F578F",
".w c #2D558D",
".e c #CAD6E5",
".r c #F9FBFC",
".t c #C6D2E1",
".y c #7396C1",
".u c #90A5C3",
".i c #6F92BD",
".p c #456CA1",
".a c #9FB7D5",
".s c #436A9F",
".d c #5D7CA8",
".f c #718DB5",
".g c #E3E8F0",
".h c #385E94",
".j c #9DB7D6",
".k c #D1DBE8",
".l c #47699C",
".z c #A0B4CF",
".x c #3A6299",
".c c #254F8B",
".v c #386097",
".b c #234D89",
".n c #224B88",
".m c #EFF3F8",
".M c #7191BB",
".N c #EBEFF4",
".B c #89A1C2",
".V c #CCD7E6",
".C c #FBFCFD",
".Z c #789BC5",
".A c None",
/* pixels */
".A.A.A.A.A.7.7.7.7.7.7.A.A.A.A.A",
".A.A.A.A.# ^ F.N.N F $.#.A.A.A.A",
".A.A.7 u.g.  U ! ! U - @ C.7.A.A",
".A.A 3.@ (.l w s 9.9 e 1.O.d.A.A",
".A 8 Q ).7 S : ..<.2 f c k +.w.A",
".7.u. .7.7 # e W h.2.C X.s.+ R.7",
".7 ~ U.7.- B.X.x.B.2 6 , x V.t L",
".7 ; d ' B < H j.r g = G & N | v",
".7 ;.h i 2.x.&.O.2.1 t E T., }.n",
".7 ~.; O.v.*.= 0.e z >.3 / Z.V K",
".7.u.:.o _.p * I ].5 %.%.y A.z v",
".A 8 + l.*.. [.2.2.i q.Z.j n.q.A",
".A.A b.0 y.6 D.2.2  .Z r { J.A.A",
".A.A.7.8 M 4 o.M p.a 5.m.f `.A.A",
".A.A.A.A 7.4 Y.> a.k.$ m.A.A.A.A",
".A.A.A.A.A.7.b P P.c v.A.A.A.A.A"
};


/* mimetypes/image-x-generic.png */
/* XPM */
const char *tango_image_x_generic[] = {
/* width height ncolors chars_per_pixel */
"16 16 87 1",
/* colors */
"  c #6583AF",
". c #95A8C7",
"X c #6381AD",
"o c #617FAB",
"O c #A5B5D0",
"+ c #738EB6",
"@ c #3F516F",
"# c #384151",
"$ c #3D4F6D",
"% c #5B7BA8",
"& c #45546E",
"* c #7A8698",
"= c #5475A4",
"- c #98ABC9",
"; c #67758F",
": c #A8B8D2",
"> c #9CA7B9",
", c #839ABE",
"< c #6180AD",
"1 c #D1DCB1",
"2 c #8691A3",
"3 c #A4B8A9",
"4 c #515151",
"5 c #FEFEFE",
"6 c #485773",
"7 c #E2EBBE",
"8 c #5778A6",
"9 c #9AACCA",
"0 c #7D899D",
"q c #F6F6F6",
"w c #9EA8BA",
"e c #7892B9",
"r c #A8B7D1",
"t c #374762",
"y c #818A9A",
"u c #93A6C6",
"i c #A2B3CE",
"p c #8099BD",
"a c #FFFFFE",
"s c #405374",
"d c #889EC1",
"f c #869CBF",
"g c #455672",
"h c #435470",
"j c #96A9C8",
"k c #A6B6D1",
"l c #33476A",
"z c #FEFEF9",
"x c #3D4E6D",
"c c #888A85",
"v c #3B4C6B",
"b c #B6C5B2",
"n c #8CA1C1",
"m c #6D89B3",
"M c #415474",
"N c #C4D1AF",
"B c #EEF3CB",
"V c #475773",
"C c #818DA2",
"Z c #2F4262",
"A c #DCE5B9",
"S c #384C6E",
"D c #A7B7D1",
"F c #7590B7",
"G c #34486A",
"H c #9DAFC7",
"J c #5072A3",
"K c #6884AA",
"L c #233659",
"P c #8FA6AF",
"I c #FDFDFD",
"U c #6986B1",
"Y c #819AB8",
"T c #9FA9BB",
"R c #9EA9BA",
"E c #5F7EAA",
"W c #B3C2B7",
"Q c #728DB6",
"! c #A1B3C3",
"~ c #FCFDEE",
"^ c #8EA3C4",
"/ c #F7FADF",
"( c #495973",
") c #C5D1B1",
"_ c #3D5071",
"` c #718DA7",
"' c None",
/* pixels */
"cccccccccccccccc",
"c55555555555555c",
"cI*tttttttttt*qc",
"c5@oXK`E%8==Jtqc",
"cIh+PAB3mU  <tqc",
"cIgpNza7YeFFQtqc",
"cIV^b/~1ndff,tqc",
"cI69HW)!-j0.utqc",
"cI(r::rDkO42itqc",
"cI&TTTTRw>44ytqc",
"cItx$$xvZL44#tqc",
"cItMs_SGl4444tqc",
"cItC;;;;;;;;;tqc",
"cI*tttttttttt*qc",
"c5qqqqqqqqqqqqIc",
"cccccccccccccccc"
};


/* actions/go-previous.png */
/* XPM */
const char *tango_go_previous[] = {
/* width height ncolors chars_per_pixel */
"16 16 99 2",
/* colors */
"   c #65A827",
" . c #6EC915",
" X c #C6DEAE",
" o c #C2DCAA",
" O c #52891E",
" + c #3B7504",
" @ c #CAE0B5",
" # c #7CC833",
" $ c #67C111",
" % c #AACF88",
" & c #97DA54",
" * c #97BD72",
" = c #6BA236",
" - c #A0C37E",
" ; c #55A409",
" : c #61B70E",
" > c #A9D480",
" , c #60B50D",
" < c #87B65B",
" 1 c #3C7604",
" 2 c #C7DFB1",
" 3 c #9DC477",
" 4 c #87BB54",
" 5 c #3A7405",
" 6 c #82B74F",
" 7 c #A5DC6E",
" 8 c #457C13",
" 9 c #88BB58",
" 0 c #60A420",
" q c #B8D69B",
" w c #90BF63",
" e c #B3D296",
" r c #3D7904",
" t c #A6CF7F",
" y c #C5DEAE",
" u c #8DC459",
" i c #96CA65",
" p c #3A7304",
" a c #59AC0B",
" s c #598B29",
" d c #578927",
" f c #41790E",
" g c #ACD881",
" h c #5EA31D",
" j c #70AD35",
" k c #6EA23D",
" l c #7FB947",
" z c #C4DDAC",
" x c #7AB742",
" c c #4E9A06",
" v c #3B7604",
" b c #4D8419",
" n c #3B7404",
" m c #A5D576",
" M c #A3CA7E",
" N c #5AAD0B",
" B c #AEDB82",
" V c #65B519",
" C c #A9D77D",
" Z c #5A8C2C",
" A c #7DA855",
" S c #8BBD5C",
" D c #61B60E",
" F c #71B035",
" G c #7BB642",
" H c #66AF20",
" J c #BFDAA6",
" K c #75B23C",
" L c #B0DE83",
" P c #3F790A",
" I c #A7CD84",
" U c #FFFFFF",
" Y c #A5C982",
" T c #80B64D",
" R c #5D8D2E",
" E c #7FA956",
" W c #56A609",
" Q c #8ABC5A",
" ! c #89BC59",
" ~ c #87BA57",
" ^ c #91C064",
" / c #68A92B",
" ( c #BDD9A3",
" ) c #519E07",
" _ c #5EB30D",
" ` c #94C26A",
" ' c #C8DFB1",
" ] c #A3D572",
" [ c #69C211",
" { c #66AC22",
" } c #3A7404",
" | c #5CAD0E",
".  c #7DB549",
".. c #58A90A",
".X c #437A10",
".o c #62AF17",
".O c #85B954",
".+ c #B5D497",
".@ c None",
/* pixels */
".@.@.@.@.@.@.@.@.@.@ +.@.@.@.@.@",
".@.@.@.@.@.@.@.@ n s p.@.@.@.@.@",
".@.@.@.@.@.@.@ } E ' p.@.@.@.@.@",
".@.@.@.@.@.@.X - ( @ p.@.@.@.@.@",
".@.@.@.@ n R e % ^ 2 v p p p p }",
".@.@.@ 5 A.+ ` ~ S z y X y z o p",
".@.@ 8 * I T.  6.O 9 ! Q ! 9 J p",
" + Z Y w j K G l x F   h 0 / q p",
" + d 3 4 { H.o | a.. ; ) c c M p",
".@.@ f < i V , : D _ N W ) c M p",
".@.@.@ + k m # [ $ B g > t M M p",
".@.@.@.@ v O ] & . L r p p p p }",
".@.@.@.@.@.@ P u 7 L p.@.@.@.@.@",
".@.@.@.@.@.@.@ 1 = C p.@.@.@.@.@",
".@.@.@.@.@.@.@.@ v b p.@.@.@.@.@",
".@.@.@.@.@.@.@.@.@.@ +.@.@.@.@.@"
};


/* actions/system-log-out.png */
/* XPM */
const char *tango_system_log_out[] = {
/* width height ncolors chars_per_pixel */
"16 16 186 2",
/* colors */
"   c #E26E6E",
" . c #D94141",
" X c #E5E6E4",
" o c #ECE3E1",
" O c #AFAFAF",
" + c #ADADAD",
" @ c #ABABAB",
" # c #A9A9A9",
" $ c #A7A7A7",
" % c #E88E8E",
" & c #A5A5A5",
" * c #A3A3A3",
" = c #5C5E5A",
" - c #A1A1A1",
" ; c #A20E0E",
" : c #585A56",
" > c #9D9D9D",
" , c #565854",
" < c #D23D3D",
" 1 c #999999",
" 2 c #979797",
" 3 c #959595",
" 4 c #939393",
" 5 c #AC1111",
" 6 c #919191",
" 7 c #8F8F8F",
" 8 c #8D8D8D",
" 9 c #8B8B8B",
" 0 c #898989",
" q c #EA9696",
" w c #E16969",
" e c #F1F1EF",
" r c #858585",
" t c #A50000",
" y c #EFEFED",
" u c #645F5E",
" i c #7F7F7F",
" p c #EB9A9A",
" a c #797979",
" s c #A60404",
" d c #757575",
" f c #A11616",
" g c #E88D8D",
" h c #6F6F6F",
" j c #D9DBD7",
" k c #A61111",
" l c #D7D9D5",
" z c #656565",
" x c #D23C3C",
" c c #989897",
" v c #DB4848",
" b c #D21B1B",
" n c #5D5D5D",
" m c #C7C9C5",
" M c #C6C9C4",
" N c #595959",
" B c #B02121",
" V c #898A88",
" C c #EA9595",
" Z c #CF0E0E",
" A c #878886",
" S c #EDD4D3",
" D c #FAFAFA",
" F c #E78888",
" G c #A60303",
" H c #CD6161",
" J c #686A67",
" K c #D32525",
" L c #9A9B98",
" P c #D73636",
" I c #D79292",
" U c #929390",
" Y c #8A6464",
" T c #C6C8C3",
" R c #B12221",
" E c #8D8F8B",
" W c #DD5656",
" Q c #B51B1B",
" ! c #C42D2D",
" ~ c #D0D2D0",
" ^ c #F3F1EF",
" / c #D63838",
" ( c #7F817D",
" ) c #FBFBFA",
" _ c #D52D2D",
" ` c #BEBEBE",
" ' c #F3F3F2",
" ] c #BABABA",
" [ c #737571",
" { c #EFEFEE",
" } c #DB4D4D",
" | c #AC1515",
".  c #C46C6B",
".. c #E4E5E3",
".X c #686966",
".o c #656763",
".O c #DC5151",
".+ c #646562",
".@ c #AAAAAA",
".# c #C58886",
".$ c #61635F",
".% c #CE0808",
".& c #A6A6A6",
".* c #5F615D",
".= c #A4A4A4",
".- c #A2A2A2",
".; c #5B5D59",
".: c #C5C7C1",
".> c #A0A0A0",
"., c #595B57",
".< c #9E9E9E",
".1 c #575955",
".2 c #9C9C9C",
".3 c #555753",
".4 c #9A9A9A",
".5 c #989898",
".6 c #969696",
".7 c #949494",
".8 c #BC2424",
".9 c #929292",
".0 c #867979",
".q c #8C8C8C",
".w c #F4F4F2",
".e c #888888",
".r c #868686",
".t c #858685",
".y c #F0F0EE",
".u c #DB4C4C",
".i c #BC3E3E",
".p c #828282",
".a c #808080",
".s c #7E7E7E",
".d c #767676",
".f c #707070",
".g c #7E6A6A",
".h c #6E6E6E",
".j c #D8DAD6",
".k c #C53636",
".l c #A2A3A1",
".z c #6C6C6C",
".x c #AC2524",
".c c #D6D8D4",
".v c #AA0B0B",
".b c #D4D6D2",
".n c #B01E1E",
".m c #686868",
".M c #646464",
".N c #DA9696",
".B c #606060",
".V c #B72828",
".C c #A51413",
".Z c #D11A1A",
".A c #C3C6C1",
".S c #8B7373",
".D c #BC3030",
".F c #FFFFFF",
".G c #FBFBFB",
".H c #F9F9F9",
".J c #D43A3A",
".K c #ECA7A7",
".L c #C76565",
".P c #696B68",
".I c #C6C9C3",
".U c #A90C0C",
".Y c #BEC1BB",
".T c #CE0C0C",
".R c #D33535",
".E c #DB4A4A",
".W c #C45151",
".Q c #C3C3C3",
".! c #F8F8F7",
".~ c #F6F6F5",
".^ c #BB4948",
"./ c #CF1010",
".( c #F4F4F3",
".) c #BDBDBD",
"._ c #BBBBBB",
".` c #B64543",
".' c #A50101",
".] c #EDEEEC",
".[ c #D26565",
".{ c #B93C3C",
".} c #6D6E6B",
".| c #A28988",
"X  c #D55E5E",
"X. c None",
/* pixels */
".;.3.3.3.3.3.3.3 , =.+.X J.o.}X.",
".3.& r a.h z n N y e.(.~.~.] (X.",
".3 +.q i d.z.M.B y '.! ).G.H LX.",
".3 ] 3 0.s d.h.m {.w.H I.i D.lX.",
".3._ >.7 0 i.d.f.y ^.L.W | S.|X.",
".3.).> 2 7.r.s.d o.{ H.K.D.V R.'",
".3 `.-.4 6.e.a.g B.[ F % C q p.'",
".3 `.=.2 4 9 Y kX  w v.E.u } g G",
".3 ` $.<.6 8 f.k W _ K.Z./ b   s",
".3 ` # -.5 7.S ; ! P.%.T.T Z.O.'",
".3 `.@ *.4.9 0.0.x.8 / ..J x < t",
".3 `.@ & > 3 7.p u.^ Q.R s.n.C.v",
".3 `.@ # - 1 h V ~...  5.U X AX.",
".3 ` @ O.t E m.b l.j j.#.`.c [X.",
".3.Q c U.Y.A T.I M M M M M.:.$X.",
".;.P ,.1 : : : :.,.,.,.,., :.*X."
};


/* actions/list-remove.png */
/* XPM */
const char *tango_list_remove[] = {
/* width height ncolors chars_per_pixel */
"16 16 20 1",
/* colors */
"  c #000000",
". c #7DA6D7",
"X c #86ADD9",
"o c #9FBEE0",
"O c #B6CCE6",
"+ c #83AAD8",
"@ c #BBD1E7",
"# c #7FA8D7",
"$ c #94B6DB",
"% c #3465A4",
"& c #95B7DB",
"* c #B5CCE6",
"= c #B4CCE5",
"- c #92B4DA",
"; c #B6CDE6",
": c #B7CEE6",
"> c #90B3DA",
", c #C0D3E8",
"< c #BCD1E7",
"1 c None",
/* pixels */
"1111111111111111",
"1111111111111111",
"1111111111111111",
"1111111111111111",
"1111111111111111",
"1111111111111111",
"11%%%%%%%%%%%%11",
"11%,@<::::;*O%11",
"11%=&$->X+#.o%11",
"11%%%%%%%%%%%%11",
"1111111111111111",
"1111111111111111",
"1111111111111111",
"1111111111111111",
"1111111111111111",
"1111111111111111"
};


/* devices/multimedia-player.png */
/* XPM */
const char *tango_multimedia_player[] = {
/* width height ncolors chars_per_pixel */
"16 16 79 1",
/* colors */
"  c #666864",
". c #626460",
"X c #858782",
"o c #80817D",
"O c #7E7F7B",
"+ c #7D7F7A",
"@ c #7C7D79",
"# c #7B7D78",
"$ c #CBCFAC",
"% c #7A7B77",
"& c #696B66",
"* c #CBD0A5",
"= c #676964",
"- c #C9D0A3",
"; c #A4A6A3",
": c #D1D6AE",
"> c #5B5B58",
", c #BDC58D",
"< c #B2B796",
"1 c #C3C996",
"2 c #8A8C89",
"3 c #B8B9B6",
"4 c #A5A7A3",
"5 c #989996",
"6 c #C3C79F",
"7 c #BFC59B",
"8 c #C5C9A4",
"9 c #838581",
"0 c #7C7D7A",
"q c #AEAEAB",
"w c #A8AAA5",
"e c #6E6F6C",
"r c #A2A49F",
"t c #BEC496",
"y c #969893",
"u c #92948F",
"i c #91928E",
"p c #BBC096",
"a c #555753",
"s c #535551",
"d c #888A85",
"f c #80827D",
"g c #B8BCAA",
"h c #CFD4B0",
"j c #7E807B",
"k c #7C7E79",
"l c #7A7C77",
"z c #787A75",
"x c #747671",
"c c #70726D",
"v c #6E706B",
"b c #6C6E69",
"n c #6A6C67",
"m c #686A65",
"M c #9B9D9A",
"N c #939592",
"B c #C3CA96",
"V c #B6B6B4",
"C c #B4B5A8",
"Z c #BBC291",
"A c #ADAEAB",
"S c #A5A6A3",
"D c #A4A6A2",
"F c #9FA09D",
"G c #696968",
"H c #B8BCA8",
"J c #B3BC78",
"K c #B6BAA6",
"L c #898A87",
"P c #C4CAA3",
"I c #C5CB9A",
"U c #B9B9B6",
"Y c #C9CEAB",
"T c #787A76",
"R c #767874",
"E c #BBC286",
"W c #747672",
"Q c #A6A7A3",
"! c None",
/* pixels */
"saaaaaaaaaaaaaaa",
"aRQQQ444444S;DRa",
"a5i%%%@@@@@Ood5a",
"a5N<68Y$P7tZh25a",
"a5rpBI-*1,EJ:y5a",
"a5uCgHHHHHHKKX5a",
"a5vbbnbvbnnbnn5a",
"a5&=m==&m==&=m5a",
"a5zqMwAWxWc>. 5a",
"a5L3DVU+++TG0e5a",
"a5+++++++++9fj5a",
"a5kkkkkkkkkkkk5a",
"a5#F#F########5a",
"a5llllllllllll5a",
"aR555555555555Ra",
"aaaaaaaaaaaaaaaa"
};


/* apps/internet-web-browser.png */
/* XPM */
const char *tango_internet_web_browser[] = {
/* width height ncolors chars_per_pixel */
"16 16 167 2",
/* colors */
"   c #000000",
" . c #56719D",
" X c #6984A9",
" o c #DCE1E5",
" O c #F1F2F3",
" + c #8BA7C7",
" @ c #84A6CA",
" # c #DFEFFF",
" $ c #93B6DC",
" % c #EDEEEF",
" & c #5A79A4",
" * c #5979A3",
" = c #5877A2",
" - c #BCC4CC",
" ; c #B1C0D5",
" : c #E3E4E5",
" > c #5685B7",
" , c #B1CEEC",
" < c #627CA5",
" 1 c #B3C1D0",
" 2 c #F0F4F8",
" 3 c #B5BEC8",
" 4 c #CCDDEF",
" 5 c #DBDEE0",
" 6 c #7591B4",
" 7 c #759FCB",
" 8 c #BED4EB",
" 9 c #F8F9F9",
" 0 c #B7C2CD",
" q c #BECFE1",
" w c #BCCDDF",
" e c #5B7AA4",
" r c #B5C5D8",
" t c #5978A2",
" y c #93ABC7",
" u c #C6CFD8",
" i c #D4DDE9",
" p c #A3B8D0",
" a c #A0B4CD",
" s c #BEC7D0",
" d c #CAD5DF",
" f c #5988BC",
" g c #E0E3E4",
" h c #DFE1E3",
" j c #83A7CE",
" k c #637FA8",
" l c #617FA6",
" z c #FEFEFE",
" x c #D7D9DB",
" c c #DCE4ED",
" v c #F6F6F6",
" b c #5E7DA6",
" n c #628FC1",
" m c #CCD9E7",
" M c #E6EBF0",
" N c #C0C6CE",
" B c #57759F",
" V c #DBE4EF",
" C c #E2E2E2",
" Z c #80A7D1",
" A c #E0E0E0",
" S c #B7C8DC",
" D c #B1C2D6",
" F c #DCE3E9",
" G c #6B96C6",
" H c #7A95B7",
" J c #BABFC4",
" K c #A9BCD1",
" L c #D9E1E9",
" P c #CED0D1",
" I c #6983A6",
" U c #C8CFD5",
" Y c #7591B5",
" T c #9DA6AE",
" R c #6D90B7",
" E c #D2E5F9",
" W c #819ABA",
" Q c #DEE2E7",
" ! c #D6DFE9",
" ~ c #A3B6CE",
" ^ c #DAEAFA",
" / c #CFD9E2",
" ( c #5A7AA4",
" ) c #5C8ABD",
" _ c #A2BDDA",
" ` c #D5DFEB",
" ' c #A5B7C9",
" ] c #CCD7E2",
" [ c #C3D2E3",
" { c #5686BA",
" } c #E3F1FF",
" | c #C8CED4",
".  c #E2EFFE",
".. c #7792B6",
".X c #516994",
".o c #9BB2CC",
".O c #9AB0CB",
".+ c #839BBB",
".@ c #C9E1F9",
".# c #F4F4F5",
".$ c #CED1D3",
".% c #E0EFFF",
".& c #4F80B6",
".* c #CEDBEA",
".= c #5D7DA6",
".- c #5A79A3",
".; c #5877A1",
".: c #E0E5EB",
".> c #94ACC8",
"., c #7E97B9",
".< c #6C96C5",
".1 c #BECBDA",
".2 c #E6EBF4",
".3 c #DAEBFC",
".4 c #D4E5F6",
".5 c #E4E6E8",
".6 c #E2E4E6",
".7 c #9CBDE0",
".8 c #6380A8",
".9 c #C7CDD2",
".0 c #ACCAE9",
".q c #BBC9DA",
".w c #9DB3CD",
".e c #5E7AA3",
".r c #FDFDFD",
".t c #BCD7F2",
".y c #FBFBFB",
".u c #5A769F",
".i c #F9F9F9",
".p c #58749D",
".a c #AABED3",
".s c #F5F5F5",
".d c #E1F0FF",
".f c #EFEFEF",
".g c #BECAD6",
".h c #BCC8D4",
".j c #5876A0",
".k c #719BC9",
".l c #B5D1EE",
".z c #B8BFC6",
".x c #576F95",
".c c #D5DFE9",
".v c #DEEEFF",
".b c #B8C9DD",
".n c #627BA3",
".m c #101221",
".M c #AEB5BC",
".N c #AFBFD4",
".B c #4B6189",
".V c #D3D3D3",
".C c #D1D1D1",
".Z c #7994B6",
".A c #DCDDDF",
".S c #B4C7DC",
".D c #9FB4CE",
".F c #A4B5C9",
".G c #9CB2CB",
".H c #708AAD",
".J c #CCE3FA",
".K c #ABBDD3",
".L c #B3CCE8",
".P c #E2F1FF",
".I c #617FA8",
".U c #DEEDFB",
".Y c #D5E8FC",
".T c #5977A0",
".R c None",
/* pixels */
".R.R.R.R.R.j e ( t =.R.R.R.R.R.R",
".R.R.R.e.+.q c.2 ` D., *.R.R.R.R",
".R.R l ;.: / J.1 8.g L ~.-.R.R.R",
".R X.N Q.$. .U.4.h N 5 M a (.R.R",
".n W 2 : d.P } ^ u x.#.y.c.Z.R.R",
".H r g 4.%.d.d.3.9 s.F 3.5 p (.R",
".8 i.a.J.v # #.*.r z.r.6.A w (.R",
" e V.0.t.@.Y E U z z z.i.M [ (.R",
" b m 0 |.L.l , K 9 O z.f P.b (.R",
" k.K o z h _.7 $ @ +.s C T.w (.R",
" < H ! z z % j Z 7.< A.V ' Y.R.R",
".R.I.G F v.z.k G n f.C -.> (.R.R",
".R.R.=.O ] R ) {.& > 1 y *.R.R.R",
".R.R.R I...D S q.S.o 6.T.R.R.R.R",
".R.R.R.R.x.u.- & t.p.R.R.R.R.R.R",
".R.R.R.R.R.R.R.R.R.R.R.R.R.R.R.R"
};


/* actions/list-add.png */
/* XPM */
const char *tango_list_add[] = {
/* width height ncolors chars_per_pixel */
"16 16 20 1",
/* colors */
"  c #000000",
". c #7DA6D7",
"X c #86ADD9",
"o c #9FBEE0",
"O c #B6CCE6",
"+ c #83AAD8",
"@ c #BBD1E7",
"# c #7FA8D7",
"$ c #94B6DB",
"% c #3465A4",
"& c #95B7DB",
"* c #B5CCE6",
"= c #B4CCE5",
"- c #92B4DA",
"; c #B6CDE6",
": c #B7CEE6",
"> c #90B3DA",
", c #C0D3E8",
"< c #BCD1E7",
"1 c None",
/* pixels */
"1111111111111111",
"1111111111111111",
"111111%%%%111111",
"111111%::%111111",
"111111%::%111111",
"111111%::%111111",
"11%%%%%::%%%%%11",
"11%,@<::::;*O%11",
"11%=&$->X+#.o%11",
"11%%%%%XX%%%%%11",
"111111%:X%111111",
"111111%:X%111111",
"111111%::%111111",
"111111%%%%111111",
"1111111111111111",
"1111111111111111"
};


/* apps/preferences-desktop-font.png */
/* XPM */
const char *tango_preferences_desktop_font[] = {
/* width height ncolors chars_per_pixel */
"16 16 79 1",
/* colors */
"  c #000000",
". c #B1B1B1",
"X c #ADADAD",
"o c #A7A7A7",
"O c #797979",
"+ c #EAEBEB",
"@ c #E9E9EA",
"# c #E8E9E9",
"$ c #5F5F5F",
"% c #4D4D4D",
"& c #4B4B4B",
"* c #FCFCFC",
"= c #494949",
"- c #FAFAFA",
"; c #474747",
": c #F8F8F8",
"> c #F6F6F6",
", c #F4F4F4",
"< c #F2F2F2",
"1 c #F0F0F0",
"2 c #EEEEEE",
"3 c #ECECEC",
"4 c #E8E8E8",
"5 c #E6E6E6",
"6 c #E5E6E5",
"7 c #E4E4E4",
"8 c #E2E2E2",
"9 c #2F2F2F",
"0 c #CECECE",
"q c #050505",
"w c #EAE9E9",
"e c #010101",
"r c #E8E7E7",
"t c #E7E7E6",
"y c #8A8C87",
"u c #888A85",
"i c #828282",
"p c #7C7C7C",
"a c #767676",
"s c #747474",
"d c #E4E4E5",
"f c #666666",
"g c #626262",
"h c #565656",
"j c #FFFFFF",
"k c #FDFDFD",
"l c #4A4A4A",
"z c #FBFBFB",
"x c #484848",
"c c #F9F9F9",
"v c #F7F7F7",
"b c #F5F5F5",
"n c #F3F3F3",
"m c #F1F1F1",
"M c #EFEFEF",
"N c #EDEDED",
"B c #ECEDEC",
"V c #ECEBEC",
"C c #EBEBEB",
"Z c #EAEBEA",
"A c #E9E9E9",
"S c #E6E7E6",
"D c #343434",
"F c #E4E5E4",
"G c #E4E3E4",
"H c #E3E3E3",
"J c #2E2E2E",
"K c #2C2C2C",
"L c #DBDBDB",
"P c #222222",
"I c #D3D3D3",
"U c #202020",
"Y c #BFBFBF",
"T c #B8B9B8",
"R c #060606",
"E c #ECECEB",
"W c #040404",
"Q c #EBEAEA",
"! c None",
/* pixels */
"!uuuuuuuuuuuuuu!",
"ujjjjjjjjjjjjjju",
"ujHoi99H5555HHku",
"ujH8L09H4A44HHku",
"ujH.9s95S56dGHku",
"ujH9IY9AAw#r5Fzu",
"uj7999T&9BV+Atzu",
"uj53N2M;K1M2E@:u",
"uj4NM1mxUD eg<>u",
"ujwM1<nx a<f .Mu",
"ujZ1<nb=qncL pMu",
"ujCmn,>=RmzI aMu",
"uj+<,>vl Ov$ XMu",
"ujQ<,>:hJPW %vMu",
"uj******--->>>Mu",
"!uuuuuuuuuuuuuu!"
};


/* actions/process-stop.png */
/* XPM */
const char *tango_process_stop[] = {
/* width height ncolors chars_per_pixel */
"16 16 136 2",
/* colors */
"   c #000000",
" . c #BF0000",
" X c #EB4C4C",
" o c #F68888",
" O c #D89292",
" + c #E8BCBC",
" @ c #FCF7F7",
" # c #EF6A6A",
" $ c #DB3C3C",
" % c #ED4747",
" & c #DF2C2C",
" * c #B22424",
" = c #B82323",
" - c #D75F5F",
" ; c #D52F2F",
" : c #F58383",
" > c #C41B1B",
" , c #B41F1F",
" < c #F26969",
" 1 c #C10101",
" 2 c #CC0F0F",
" 3 c #E4AAAA",
" 4 c #E9A5A5",
" 5 c #F68787",
" 6 c #D22F2F",
" 7 c #C70000",
" 8 c #BF1919",
" 9 c #F78B8B",
" 0 c #E6A5A5",
" q c #D13131",
" w c #DF2B2B",
" e c #BF0505",
" r c #D85C5C",
" t c #CF2F2F",
" y c #BD0303",
" u c #E83737",
" i c #E6E0E0",
" p c #C92929",
" a c #FEFEFE",
" s c #880000",
" d c #CC2F2F",
" f c #DB4141",
" g c #C10000",
" h c #E6ABAB",
" j c #E6D9D9",
" k c #DA6464",
" l c #ECECEC",
" z c #EA3F3F",
" x c #E8E8E8",
" c c #D75757",
" v c #DACDCD",
" b c #EB4343",
" n c #D85B5B",
" m c #ED5252",
" M c #BD0202",
" N c #D31111",
" B c #BC1818",
" V c #E6DFDF",
" C c #E63434",
" Z c #B32626",
" A c #AF2222",
" S c #DB4040",
" D c #B41D1D",
" F c #EC6161",
" G c #EF5A5A",
" H c #890303",
" J c #D65F5F",
" K c #ED6565",
" L c #D85A5A",
" P c #D65858",
" I c #DA3B3B",
" U c #E39696",
" Y c #E5A5A5",
" T c #BE0505",
" R c #CE2F2F",
" E c #C30000",
" W c #D01010",
" Q c #E73737",
" ! c #B01818",
" ~ c #D21F1F",
" ^ c #890202",
" / c #CB0101",
" ( c #870000",
" ) c #E83B3B",
" _ c #CE2828",
" ` c #F17575",
" ' c #EE6868",
" ] c #BD0000",
" [ c #F3EDED",
" { c #F68A8A",
" } c #DB5F5F",
" | c #C70303",
".  c #B12222",
".. c #BE0404",
".X c #D75B5B",
".o c #E5DFDF",
".O c #E94545",
".+ c #C71D1D",
".@ c #B72121",
".# c #F9F9F9",
".$ c #DC4242",
".% c #B11B1B",
".& c #F1F1F1",
".* c #9E3333",
".= c #EDEDED",
".- c #F58585",
".; c #F38383",
".: c #DFDFDF",
".> c #DA6767",
"., c #DBDBDB",
".< c #F68989",
".1 c #D23131",
".2 c #A43F3F",
".3 c #D02F2F",
".4 c #C50000",
".5 c #D93B3B",
".6 c #D53737",
".7 c #DE9292",
".8 c #DF2D2D",
".9 c #F06F6F",
".0 c #890000",
".q c #C51A1A",
".w c #B11A1A",
".e c #D63B3B",
".r c #D52323",
".t c #EC4A4A",
".y c #E2DEDE",
".u c #D89999",
".i c #DEACAC",
".p c #B82424",
".a c #D76060",
".s c #D53030",
".d c #DAD6D6",
".f c #880202",
".g c #860000",
".h c None",
/* pixels */
".h.h.h.h.0.g.g.g.g.g.g.0.h.h.h.h",
".h.h.h.0 A o 9 9 { 5 : =.0.h.h.h",
".h.h.0. .;.$ ; ; ; ; $ ` ,.0.h.h",
".h.0 *.;.$.6 ; ; ; ;.6 I.9.%.0.h",
".0 Z.; f c v - ; ; r j }.5 # !.0",
".f.< S ; O.,.d.a L i.= Y 6.e '.f",
" H o ; ;.s.u.:.y V l h.1.3 R K ^",
" H o ; ; ;.s.i x l + q t R d F ^",
" H o ; ; ; n V l.& [ k R d p.O ^",
" H.- ; ;.X.o l 3 0.# @.>.q M u ^",
".f <.r ~.7 l 3.3 _ 4 a U ] y C ^",
".0.p G N / P |.4 E 1 J M.. w.+ (",
".h.0.@ m W 7.4 E g . ] T & > s.h",
".h.h.0 D X 2 E g . ] e.8 8 s.h.h",
".h.h.h.0.w.t % b z ) Q B s.h.h.h",
".h.h.h.h.0.g.g.g.g.g.g s.h.h.h.h"
};


/* actions/view-refresh.png */
/* XPM */
const char *tango_view_refresh[] = {
/* width height ncolors chars_per_pixel */
"16 16 100 2",
/* colors */
"   c #9DBDDC",
" . c #6990C0",
" X c #3767A6",
" o c #3667A5",
" O c #3565A4",
" + c #DDE8F3",
" @ c #8AACD3",
" # c #99B9DB",
" $ c #B4CBE5",
" % c #D8E4F1",
" & c #5783BB",
" * c #537FB7",
" = c #4B77AF",
" - c #A0BEDE",
" ; c #3868A6",
" : c #3768A5",
" > c #4C79B3",
" , c #769DCF",
" < c #5580B5",
" 1 c #97B6D8",
" 2 c #8FACD0",
" 3 c #E4ECF5",
" 4 c #4E7AB1",
" 5 c #C8D8EA",
" 6 c #4C78AF",
" 7 c #8FB0D3",
" 8 c #6D94C2",
" 9 c #6891C7",
" 0 c #3C6BA9",
" q c #3A69A7",
" w c #3969A6",
" e c #C6D8EB",
" r c #4774AD",
" t c #C1D2E6",
" y c #6890C0",
" u c #CDDBEB",
" i c #3465A4",
" p c #6188B9",
" a c #DBE6F2",
" s c #BFD2E7",
" d c #84A6CE",
" f c #E5EDF5",
" g c #C9D9EA",
" h c #8FADD2",
" j c #A1BEDD",
" k c #3A6AA6",
" l c #E2EBF5",
" z c #88A7CE",
" x c #3768A6",
" c c #95B2D4",
" v c #3566A4",
" b c #C4D7EB",
" n c #4371AB",
" m c #A1BBD9",
" M c #E7EEF6",
" N c #BFD3E9",
" B c #5F87B9",
" V c #7298C5",
" C c #5D85B7",
" Z c #6C95C9",
" A c #82A5CE",
" S c #9CB7D7",
" D c #C9DAEC",
" F c #E3ECF5",
" G c #4C78B0",
" H c #8EAED3",
" J c #4F7CB6",
" K c #3969A7",
" L c #3869A6",
" P c #3767A5",
" I c #A8C2DF",
" U c #93B1D4",
" Y c #4170AB",
" T c #CCDDEE",
" R c #B0C9E3",
" E c #E5EDF6",
" W c #E4EDF5",
" Q c #FFFFFF",
" ! c #4D79B0",
" ~ c #C7D7E9",
" ^ c #4C77AF",
" / c #5B84B7",
" ( c #D5E2F0",
" ) c #3C6CA9",
" _ c #3A6AA7",
" ` c #E0E9F4",
" ' c #A8C1DE",
" ] c #8CADD3",
" [ c #B4CAE3",
" { c #3566A5",
" } c #7299CD",
" | c #88ABD2",
".  c #CCDCED",
".. c #E6EEF6",
".X c #BCD1E7",
".o c #7EA4D5",
".O c #3D6DA9",
".+ c #3C6BA8",
".@ c #3B6BA7",
".# c None",
/* pixels */
".#.#.#.# q _ o K _.#.#.#.#.#.#.#",
".#.#.# ; y 7 I ' U B P.#.#.# i.#",
".#.# w ]   j $ N T ( s = o n v.#",
".# K . V.+ v _ C m % a + z 5 _.#",
".# ; Y ) _.#.#.# L p u l.... _.#",
".# O _ 9 P.#.#.#.#.# v ~ e F k.#",
".# i.#.#.#.#.#.#.# ; 2 M a.. k.#",
".#.#.#.#.#.#.#.# i i r ^ ^ 6 i.#",
".# i i i i i i i.#.#.#.#.#.#.#.#",
".# i f E 3 S x.#.#.#.#.#.#.# i.#",
".# v.. b g i.#.#.#.#.# { Z * i.#",
".# P.. F W t ! L.#.#.# 0 J _ :.#",
".# ; % c ` +.  h G { w w.O G _.#",
".# P / o 4 [ D.X R - | A H ;.#.#",
".# i o.#.# X < d 1 # @ 8 ;.#.#.#",
".# i.#.#.#.#.# _ L v _.@.#.#.#.#"
};


/* actions/go-next.png */
/* XPM */
const char *tango_go_next[] = {
/* width height ncolors chars_per_pixel */
"16 16 101 2",
/* colors */
"   c #8BBB5D",
" . c #78B63D",
" X c #9CD267",
" o c #A7D17F",
" O c #B7D49C",
" + c #6EAC33",
" @ c #C3DCAB",
" # c #9EC976",
" $ c #C2DCAA",
" % c #66B817",
" & c #8AC255",
" * c #CBE0B6",
" = c #3B7504",
" - c #5AAC0B",
" ; c #66BF10",
" : c #5F8F31",
" > c #5E8F30",
" , c #82AB5A",
" < c #6FBA26",
" 1 c #9CC37A",
" 2 c #54A408",
" 3 c #89C350",
" 4 c #61B70E",
" 5 c #BBD99F",
" 6 c #6CBF1C",
" 7 c #C0DBA7",
" 8 c #74AF3B",
" 9 c #4F9C06",
" 0 c #3C7804",
" q c #3C7604",
" w c #4D8418",
" e c #A4CC7E",
" r c #8BC158",
" t c #AFD48C",
" y c #CEE3BB",
" u c #3A7405",
" i c #598C2A",
" p c #467C14",
" a c #B1D291",
" s c #88BB58",
" d c #ABD781",
" f c #A4C684",
" g c #91C164",
" h c #5FB20E",
" j c #C7DEB0",
" k c #C6DEAF",
" l c #40790A",
" z c #3A7304",
" x c #568926",
" c c #9BCA6D",
" v c #81AB5A",
" b c #52A007",
" n c #A5D773",
" m c #C5DDAD",
" M c #4E9A06",
" N c #3B7604",
" B c #3B7404",
" V c #A3CA7E",
" C c #427A0E",
" Z c #80BE44",
" A c #8BBD5C",
" S c #64BA11",
" D c #AAD581",
" F c #82BE49",
" G c #92D352",
" H c #6BAC2F",
" J c #538B1E",
" K c #A8DA78",
" L c #5BAE0B",
" P c #6CBA1F",
" I c #8DC25A",
" U c #FFFFFF",
" Y c #8CBE5C",
" T c #8BBC5B",
" R c #ABD681",
" E c #62B90E",
" W c #B9D79C",
" Q c #71A63E",
" ! c #A0D56C",
" ~ c #68A92B",
" ^ c #9DC873",
" / c #BDD9A3",
" ( c #99C46F",
" ) c #5EB30D",
" _ c #7FCB34",
" ` c #8CC358",
" ' c #CBE1B7",
" ] c #3A7404",
" [ c #8DC15C",
" { c #57A709",
" } c #437A10",
" | c #64BC0F",
".  c #88C44D",
".. c #AACE89",
".X c #85B954",
".o c #84C249",
".O c #A6D37B",
".+ c #8FC161",
".@ c #6AA136",
".# c #8DC655",
".$ c None",
/* pixels */
".$.$.$.$.$ =.$.$.$.$.$.$.$.$.$.$",
".$.$.$.$.$ z i ].$.$.$.$.$.$.$.$",
".$.$.$.$.$ z ' , ].$.$.$.$.$.$.$",
".$.$.$.$.$ z y @ f }.$.$.$.$.$.$",
" ] z z z z N * ( a O : B.$.$.$.$",
" z 7 $ m k j j g.+ ^ 5 v u.$.$.$",
" z /.X s T A Y [ I & ` t 1 p.$.$",
" z W 8 + ~ H . F 3. .o Z c.. > =",
" z V M M M b { L h % P <.# # x =",
" z V M M 9 2 - ) E | 6 X   C.$.$",
" z V V V e o D 4 ; _ K Q N.$.$.$",
" ] z z z z 0 R S G n J q.$.$.$.$",
".$.$.$.$.$ z d ! r l.$.$.$.$.$.$",
".$.$.$.$.$ z.O.@ q.$.$.$.$.$.$.$",
".$.$.$.$.$ z w N.$.$.$.$.$.$.$.$",
".$.$.$.$.$ =.$.$.$.$.$.$.$.$.$.$"
};


/* actions/document-save-as.png */
/* XPM */
const char *tango_document_save_as[] = {
/* width height ncolors chars_per_pixel */
"16 16 101 2",
/* colors */
"   c #000000",
" . c #739FC0",
" X c #6C8577",
" o c #81ADD1",
" O c #DFE2DE",
" + c #DCDCDB",
" @ c #8FB3CE",
" # c #96BBD8",
" $ c #4A7180",
" % c #95A9AF",
" & c #B7B8B6",
" * c #4E6A7D",
" = c #3D698A",
" - c #AFB0AE",
" ; c #AEB0AD",
" : c #ACCBE3",
" > c #ABCBE2",
" , c #EDEDEE",
" < c #E9E9EA",
" 1 c #A2A4A1",
" 2 c #6B716E",
" 3 c #9BC2DF",
" 4 c #38678B",
" 5 c #6E99B6",
" 6 c #FCFCFC",
" 7 c #FAFAFA",
" 8 c #6B7F88",
" 9 c #F4F4F4",
" 0 c #F3F4F3",
" q c #F2F2F2",
" w c #CED4C8",
" e c #F0F0F0",
" r c #EFEEEF",
" t c #EEEEEE",
" y c #EDEEED",
" u c #ECECEC",
" i c #627075",
" p c #3F6C8E",
" a c #719FBF",
" s c #E4E4E4",
" d c #79A7CA",
" f c #DCDCDC",
" g c #DBDCDB",
" h c #C9D6DD",
" j c #DDE1D6",
" k c #D5DFE5",
" l c #AEB0AE",
" z c #44789F",
" x c #5186AF",
" c c #7798B0",
" v c #ACBCC3",
" b c #DCDBDB",
" n c #C5DBEC",
" m c #3D6B8E",
" M c #58787A",
" N c #C1D9EB",
" B c #6A7F5A",
" V c #3B6B8F",
" C c #9EBFD9",
" Z c #E2E6DD",
" A c #9AAEB4",
" S c #ABC8DF",
" D c #6E706B",
" F c #92A6AC",
" G c #EEEEEF",
" H c #EDEEEE",
" J c #427092",
" K c #EBECEC",
" L c #688BA0",
" P c #D0DFEF",
" I c #6296BB",
" U c #DBDCDC",
" Y c #72756B",
" T c #92B7D3",
" R c #667173",
" E c #98BFDC",
" W c #FFFFFF",
" Q c #FDFDFD",
" ! c #FCFBFC",
" ~ c #F9F9F9",
" ^ c #F7F7F7",
" / c #AFB0AD",
" ( c #F3F3F3",
" ) c #F1F1F1",
" _ c #41749A",
" ` c #EFEFEF",
" ' c #EEEFEE",
" ] c #CACFC4",
" [ c #EDEDED",
" { c #EAE9EA",
" } c #A3A4A1",
" | c #C5CBBF",
".  c #4A6D85",
".. c #436E88",
".X c #E3E3E3",
".o c #DCDBDC",
".O c #5892BD",
".+ c #B1CEE6",
".@ c #4D7991",
".# c #547D9B",
".$ c None",
/* pixels */
".$.$.$ 4 4 4 = $ M.$.$.$.$.$.$.$",
".$.$.$.+ P n 3 L...$.$.$.$.$.$.$",
" 8 R i.  _ z C N x * D D D D D D",
" 2 Z W j h 5 4 > T.# k W W W 9 D",
" Y Q t [ O c 4 d @ m v , H y 0 D",
" D ! K 4 4 4 4 d.O 4 4 4 4 u ( D",
" D 7 < ] 4 E a a a . # 4 % { q D",
" D ~ 7 s | 4 E . . S 4 F s 9 ) D",
" D ~ t 7 s | 4 : E V F s 7 t ) D",
" D ^.X t 7 7 w p 4 A 7 6 t.X e D",
" D } 1 } } } } } } } } } } } } D",
" D f b + f.o +.o f g U   + U f D",
" D ` / l - ; / / / / r   ' G r D",
" D W & & & & & & & & W   W W W D",
" D W W W W W W W W W W   W W W D",
" D D D D D D D D D D D D D D D D"
};


/* actions/document-save.png */
/* XPM */
const char *tango_document_save[] = {
/* width height ncolors chars_per_pixel */
"16 16 114 2",
/* colors */
"   c #000000",
" . c #739FC0",
" X c #AFAFAF",
" o c #6C8577",
" O c #81ADD1",
" + c #DFE2DE",
" @ c #A9A9A9",
" # c #A8A7A8",
" $ c #8FB3CE",
" % c #9F9F9F",
" & c #96BBD8",
" * c #4A7180",
" = c #95A9AF",
" - c #B7B6B6",
" ; c #4E6A7D",
" : c #3D698A",
" > c #AAAAA9",
" , c #ACCBE3",
" < c #ABCBE2",
" 1 c #EDEDEE",
" 2 c #E9E9EA",
" 3 c #6B716E",
" 4 c #9BC2DF",
" 5 c #38678B",
" 6 c #6E99B6",
" 7 c #FEFEFE",
" 8 c #FCFCFC",
" 9 c #FAFAFA",
" 0 c #6B7F88",
" q c #F4F4F4",
" w c #F3F4F3",
" e c #F2F2F2",
" r c #CED4C8",
" t c #F0F0F0",
" y c #EEEEEE",
" u c #EDEEED",
" i c #ECECEC",
" p c #627075",
" a c #3F6C8E",
" s c #719FBF",
" d c #E4E4E4",
" f c #79A7CA",
" g c #DCDCDC",
" h c #D6D6D6",
" j c #C9D6DD",
" k c #D2D2D2",
" l c #D0D0D0",
" z c #CECECE",
" x c #DDE1D6",
" c c #CACACA",
" v c #C8C8C8",
" b c #C4C4C4",
" n c #C2C2C2",
" m c #BCBCBC",
" M c #D5DFE5",
" N c #B4B4B4",
" B c #44789F",
" V c #5186AF",
" C c #7798B0",
" Z c #ACBCC3",
" A c #C5DBEC",
" S c #3D6B8E",
" D c #58787A",
" F c #C1D9EB",
" G c #6A7F5A",
" H c #3B6B8F",
" J c #9EBFD9",
" K c #E2E6DD",
" L c #9AAEB4",
" P c #ABC8DF",
" I c #6E706B",
" U c #92A6AC",
" Y c #A8A7A7",
" T c #EDEEEE",
" R c #427092",
" E c #EBECEC",
" W c #688BA0",
" Q c #D0DFEF",
" ! c #6296BB",
" ~ c #72756B",
" ^ c #92B7D3",
" / c #667173",
" ( c #98BFDC",
" ) c #FFFFFF",
" _ c #FDFDFD",
" ` c #FCFBFC",
" ' c #F9F9F9",
" ] c #F7F7F7",
" [ c #F3F3F3",
" { c #F1F1F1",
" } c #41749A",
" | c #CACFC4",
".  c #EDEDED",
".. c #EBEBEB",
".X c #EAE9EA",
".o c #C5CBBF",
".O c #4A6D85",
".+ c #436E88",
".@ c #E3E3E3",
".# c #DDDDDD",
".$ c #D5D5D5",
".% c #D1D1D1",
".& c #CFCFCF",
".* c #CDCDCD",
".= c #CBCBCB",
".- c #C9C9C9",
".; c #5892BD",
".: c #C5C5C5",
".> c #C3C3C3",
"., c #B1CEE6",
".< c #4D7991",
".1 c #B9B9B9",
".2 c #547D9B",
".3 c None",
/* pixels */
".3.3.3 5 5 5 : * D.3.3.3.3.3.3.3",
".3.3.3., Q A 4 W.+.3.3.3.3.3.3.3",
" 0 / p.O } B J F V ; I I I I I I",
" 3 K ) x j 6 5 < ^.2 M ) ) ) q I",
" ~ _ y.  + C 5 f $ S Z 1 T u w I",
" I ` E 5 5 5 5 f.; 5 5 5 5 i [ I",
" I 9 2 | 5 ( s s s . & 5 =.X e I",
" I ' 9 d.o 5 ( . . P 5 U d q { I",
" I ' y 9 d.o 5 , ( H U d 9 y { I",
" I ].@ y 9 9 r a 5 L 9 8 y.@ t I",
" I 7 ) ) ) ) ) ) ) q q.....@ t I",
" I z.-.-.-.-.:.-.-.:.:.:.:.: h I",
" I z.: % X m b v l @ k @ k.1 c I",
" I.*.> > N n b v.= #.% Y.% - c I",
" I.# g g g.$.$.&.&.&.&.&.&.& c I",
" I I I I I I I I I I I I I I I I"
};


/* actions/system-shutdown.png */
/* XPM */
const char *tango_system_shutdown[] = {
/* width height ncolors chars_per_pixel */
"16 16 66 1",
/* colors */
"  c #ABABAB",
". c #A9A9A9",
"X c #8F8F8F",
"o c #858585",
"O c #7D7D7D",
"+ c #6F6F6F",
"@ c #6D6D6D",
"# c #656565",
"$ c #616161",
"% c #5F5F5F",
"& c #555555",
"* c #515151",
"= c #F6F6F6",
"- c #F4F4F4",
"; c #F0F0F0",
": c #EEEEEE",
"> c #ECECEC",
", c #EAEAEA",
"< c #E8E8E8",
"1 c #E6E6E6",
"2 c #E4E4E4",
"3 c #E2E2E2",
"4 c #E0E0E0",
"5 c #2D2D2D",
"6 c #DEDEDE",
"7 c #2B2B2B",
"8 c #272727",
"9 c #D8D8D8",
"0 c #D4D4D4",
"q c #D2D2D2",
"w c #CCCCCC",
"e c #C2C2C2",
"r c #BCBCBC",
"t c #A6A6A6",
"y c #A2A2A2",
"u c #A0A0A0",
"i c #888A85",
"p c #8E8E8E",
"a c #848484",
"s c #808080",
"d c #7A7A7A",
"f c #6C6C6C",
"g c #606060",
"h c #F7F7F7",
"j c #F5F5F5",
"k c #F3F3F3",
"l c #F1F1F1",
"z c #EFEFEF",
"x c #EDEDED",
"c c #EBEBEB",
"v c #E9E9E9",
"b c #E7E7E7",
"n c #E5E5E5",
"m c #E3E3E3",
"M c #E1E1E1",
"N c #DFDFDF",
"B c #282828",
"V c #C9C9C9",
"C c #C7C7C7",
"Z c #C5C5C5",
"A c #C3C3C3",
"S c #C1C1C1",
"D c #BBBBBB",
"F c #B9B9B9",
"G c #B3B3B3",
"H c None",
/* pixels */
"HiiiiiiiiiiiiiiH",
"immmmmmmmmmmmmmi",
"i3mz=hhhhhhh=1mi",
"imz=jjjjjjjjjk2i",
"in-kkwaooop;kkbi",
"i1-ll*****B3ll<i",
"i<kzz&OssX84z:vi",
"iv;xxgtuGr74xx,i",
"i,zcc#.FAV5Mc,>i",
"ix,22dC>>m%22m:i",
"i:<33O6jjj+63Mzi",
"iz144oyeeDO946;i",
"iz,66wf@$f q6Nli",
"izlcMM6rSZV0M;li",
"illlllllllllllli",
"HiiiiiiiiiiiiiiH"
};


/* places/start-here.png */
/* XPM */
const char *tango_start_here[] = {
/* width height ncolors chars_per_pixel */
"16 16 53 1",
/* colors */
"  c #6593C6",
". c #5080B8",
"X c #3869A7",
"o c #3667A5",
"O c #2F5F9E",
"+ c #4474AF",
"@ c #4272AD",
"# c #234E8B",
"$ c #214C89",
"% c #204A88",
"& c #507FB7",
"* c #3A6AA8",
"= c #295694",
"- c #3868A6",
"; c #5E8CC1",
": c #214B88",
"> c #25518F",
", c #2C5B99",
"< c #3667A6",
"1 c #3465A4",
"2 c #4070AC",
"3 c #25508E",
"4 c #24508D",
"5 c #6492C5",
"6 c #2A5896",
"7 c #4E7DB6",
"8 c #3768A6",
"9 c #3566A4",
"0 c #3162A0",
"q c #30609F",
"w c #729FCF",
"e c #5B8ABF",
"r c #4575B0",
"t c #244F8C",
"y c #214B89",
"u c #204B88",
"i c #6895C8",
"p c #6795C7",
"a c #5180B8",
"s c #285593",
"d c #31619F",
"f c #2F5F9D",
"g c #5D8BC0",
"h c #FFFFFF",
"j c #6B98CA",
"k c #6996C8",
"l c #5483BA",
"z c #204A87",
"x c #3D6EAA",
"c c #2D5C9A",
"v c #3566A5",
"b c #234F8C",
"n c None",
/* pixels */
"nnnnnnnnnn%z:nnn",
"nno9-nnnnn#d6unn",
"nnxkl<nnnuq11bnn",
"nopww2nnnu111=zn",
"nowww.9nn4111cyn",
"n@www;Xnz=1110zn",
"1awwwjvnn=111qun",
"n&wwwionn3111,yn",
"n+wwweXnn$111snn",
"n*www7nnnzzzzznn",
"n11111nnnnnnnnnn",
"nnnnnnnnnzzzzznn",
"nv1111nnn:c1f:nn",
"n-gw58nnnntO>unn",
"nn2 ronnnnzzunnn",
"nnvv<nnnnnnnnnnn"
};


/* apps/system-software-update.png */
/* XPM */
const char *tango_system_software_update[] = {
/* width height ncolors chars_per_pixel */
"16 16 170 2",
/* colors */
"   c #000000",
" . c #56719D",
" X c #DCE1E5",
" o c #F1F2F3",
" O c #8BA7C7",
" + c #84A6CA",
" @ c #DFEFFF",
" # c #93B6DC",
" $ c #EDEEEF",
" % c #774861",
" & c #5A79A4",
" * c #5979A3",
" = c #5877A2",
" - c #BCC4CC",
" ; c #E3E4E5",
" : c #5685B7",
" > c #B1CEEC",
" , c #607AA3",
" < c #B3C1D0",
" 1 c #B5BEC8",
" 2 c #5B6D94",
" 3 c #5A6B93",
" 4 c #CCDDEF",
" 5 c #DBDEE0",
" 6 c #7591B4",
" 7 c #759FCB",
" 8 c #BED4EB",
" 9 c #F8F9F9",
" 0 c #B7C2CD",
" q c #BECFE1",
" w c #BCCDDF",
" e c #506A96",
" r c #5978A2",
" t c #93ABC7",
" y c #B4BCCD",
" u c #C6CFD8",
" i c #A3B8D0",
" p c #843345",
" a c #A0B4CD",
" s c #516790",
" d c #BEC7D0",
" f c #CAD5DF",
" g c #5988BC",
" h c #DFE1E3",
" j c #83A7CE",
" k c #AFB8CB",
" l c #FEFEFE",
" z c #D7D9DB",
" x c #5C77A1",
" c c #DCE4ED",
" v c #F6F6F6",
" b c #6B7B9F",
" n c #628FC1",
" m c #E6EBF0",
" M c #C0C6CE",
" N c #768BAD",
" B c #E2E2E2",
" V c #80A7D1",
" C c #E0E0E0",
" Z c #B7C8DC",
" A c #B1C2D6",
" S c #DCE3E9",
" D c #6B96C6",
" F c #705472",
" G c #9E080B",
" H c #7A95B7",
" J c #656588",
" K c #4E648F",
" L c #6F5674",
" P c #BABFC4",
" I c #A9BCD1",
" U c #D9E1E9",
" Y c #CED0D1",
" T c #6983A6",
" R c #C8CFD5",
" E c #8593B1",
" W c #546E98",
" Q c #A40000",
" ! c #D9DCDF",
" ~ c #9DA6AE",
" ^ c #6D90B7",
" / c #686284",
" ( c #991116",
" ) c #D2E5F9",
" _ c #ADB9CE",
" ` c #D6DFE9",
" ' c #A3B6CE",
" ] c #DAEAFA",
" [ c #CFD9E2",
" { c #5A7AA4",
" } c #5C8ABD",
" | c #A2BDDA",
".  c #597199",
".. c #D5DFEB",
".X c #A5B7C9",
".o c #CCD7E2",
".O c #C3D2E3",
".+ c #5686BA",
".@ c #E3F1FF",
".# c #C8CED4",
".$ c #E2EFFE",
".% c #7792B6",
".& c #516994",
".* c #9BB2CC",
".= c #9AB0CB",
".- c #9EADC5",
".; c #C9E1F9",
".: c #F4F4F5",
".> c #CED1D3",
"., c #E0EFFF",
".< c #4F80B6",
".1 c #CEDBEA",
".2 c #405583",
".3 c #5D7DA6",
".4 c #5A79A3",
".5 c #94ACC8",
".6 c #7E97B9",
".7 c #6C96C5",
".8 c #BECBDA",
".9 c #C4CAD6",
".0 c #E6EBF4",
".q c #DAEBFC",
".w c #D4E5F6",
".e c #E4E6E8",
".r c #E2E4E6",
".t c #9CBDE0",
".y c #6E5471",
".u c #95A7C2",
".i c #C7CDD2",
".p c #ACCAE9",
".a c #9DB3CD",
".s c #FDFDFD",
".d c #BCD7F2",
".f c #FBFBFB",
".g c #5A769F",
".h c #F9F9F9",
".j c #58749D",
".k c #AABED3",
".l c #F5F5F5",
".z c #E1F0FF",
".x c #EFEFEF",
".c c #BECAD6",
".v c #BCC8D4",
".b c #719BC9",
".n c #B5D1EE",
".m c #B8BFC6",
".M c #364878",
".N c #576F95",
".B c #D5DFE9",
".V c #DEEEFF",
".C c #B8C9DD",
".Z c #101221",
".A c #AEB5BC",
".S c #4B6189",
".D c #D3D3D3",
".F c #D1D1D1",
".G c #7994B6",
".H c #DCDDDF",
".J c #931821",
".K c #B4C7DC",
".L c #9FB4CE",
".P c #A4B5C9",
".I c #9CB2CB",
".U c #CCE3FA",
".Y c #B3CCE8",
".T c #E2F1FF",
".R c #617FA8",
".E c #DEEDFB",
".W c #D5E8FC",
".Q c None",
/* pixels */
".Q.M.M.M.M.M.M.M r =.Q.Q.Q.Q.Q.Q",
".Q.Q.M.M.M b c.0.. A.6 *.Q.Q.Q.Q",
".Q.Q W 3 y [ P.8 8.c U '.4.Q.Q.Q",
".Q.  3.9.>.$.E.w.v M 5 m a {.Q.Q",
" K.M k ; f.T.@ ] u z.:.f.B.G.Q.Q",
" s 2 ! 4.,.z.z.q.i d.P 1.e i {.Q",
".2 E.k.U.V @ @.1.s l.s.r.H w /.Q",
".M _.p.d.;.W ) R l l l.h.A.O F.Q",
" e.- 0.#.Y.n > I 9 o l.x Y.C L.Q",
" x.u X l h |.t # + O.l B ~.a p Q",
" , H ` l l $ j V 7.7 C.D.X N ( Q",
".Q.R.I S v.m.b D n g.F -.5 % Q.Q",
".Q.Q.3.=.o ^ }.+.< : < t J G.Q.Q",
".Q.Q.Q T.%.L Z q.K.* 6.y G.Q.Q.Q",
".Q.Q.Q.Q.N.g.4 & r.j.J Q Q Q.Q.Q",
".Q.Q.Q.Q.Q.Q.Q.Q Q Q Q Q Q Q Q.Q"
};


/* apps/system-users.png */
/* XPM */
const char *tango_system_users[] = {
/* width height ncolors chars_per_pixel */
"16 16 147 2",
/* colors */
"   c #000000",
" . c #F3BE71",
" X c #ECBD74",
" o c #4071AF",
" O c #E6AA4D",
" + c #868F41",
" @ c #4A78B2",
" # c #7E6040",
" $ c #AF7D2E",
" % c #E3A340",
" & c #3263A1",
" * c #547FB5",
" = c #905841",
" - c #616519",
" ; c #797F37",
" : c #B99355",
" > c #6C3F3B",
" , c #E3A23C",
" < c #EBAA5B",
" 1 c #4172AF",
" 2 c #F6CB8A",
" 3 c #E5A255",
" 4 c #D1A55F",
" 5 c #C0934B",
" 6 c #6D4A0A",
" 7 c #9F5203",
" 8 c #6A692B",
" 9 c #8BA6C9",
" 0 c #D08F4A",
" q c #723C51",
" w c #3E558E",
" e c #E3A256",
" r c #F3C680",
" t c #5C3B59",
" y c #3466A5",
" u c #895443",
" i c #C2893C",
" p c #6087B9",
" a c #5A3464",
" s c #C16710",
" d c #3568A9",
" f c #DDA053",
" g c #AF8033",
" h c #BC8E43",
" j c #ECB868",
" k c #C29142",
" l c #8B6B58",
" z c #8E5105",
" x c #5A85B9",
" c c #614D7E",
" v c #687214",
" b c #90563F",
" n c #DAAE6D",
" m c #D8994A",
" M c #5F86B7",
" N c #E6A251",
" B c #645370",
" V c #E0992A",
" C c #D6DBE3",
" Z c #E5A746",
" A c #3467A7",
" S c #E09B2D",
" D c #BF6C10",
" F c #767B35",
" G c #829FC5",
" H c #32629E",
" J c #B78940",
" K c #616B09",
" L c #F1BD6F",
" P c #864F06",
" I c #5E83B2",
" U c #386DB1",
" Y c #3D538B",
" T c #C77D28",
" R c #485F99",
" E c #3364A2",
" W c #3264A1",
" Q c #E1A23E",
" ! c #6F7131",
" ~ c #955104",
" ^ c #6D712F",
" / c #E8AA5C",
" ( c #B88530",
" ) c #624F0D",
" _ c #C16404",
" ` c #BA5C11",
" ' c #E5AE5C",
" ] c #D9AC64",
" [ c #DDAB5E",
" { c #815107",
" } c #AA7722",
" | c #A9A3B9",
".  c #F9C780",
".. c #A0B6D1",
".X c #C4680A",
".o c #6B8BB4",
".O c #8DA7C8",
".+ c #B68134",
".@ c #C38F44",
".# c #E2B369",
".$ c #596921",
".% c #465440",
".& c #CC5E01",
".* c #C49A52",
".= c #6A6A2B",
".- c #CC5E04",
".; c #B98633",
".: c #5C3566",
".> c #DCA552",
"., c #A35403",
".< c #55315F",
".1 c #4576B2",
".2 c #965435",
".3 c #B4C1D3",
".4 c #EFC075",
".5 c #885106",
".6 c #366BAD",
".7 c #BC7625",
".8 c #32629F",
".9 c #30609D",
".0 c #EBBC74",
".q c #5680B5",
".w c #DF8E3A",
".e c #D56402",
".r c #3466A4",
".t c #3364A3",
".y c #CB9A51",
".u c #685D14",
".i c #6E771D",
".p c #3B6EAE",
".a c #815330",
".s c #B0B6CB",
".d c #4F649A",
".f c #C99C66",
".g c #3568A8",
".h c #9E5807",
".j c #B85410",
".k c #E6AD54",
".l c #5981B4",
".z c #844240",
".x c #366AAC",
".c c #D16604",
".v c #A6ACC4",
".b c #CF9D51",
".n c #F0CE99",
".m c #CD5C00",
".M c None",
/* pixels */
".M.M.M.M P ~ z.,.M.M.M.M.M.M.M.M",
".M.M.M.c m 4.b.@ 7.M.M.M.M.M.M.M",
".M.M.h f.* 5.;.7 s.m.&.m.M.M.M.M",
".M.M.5.y h : T.X N 2 . /.m.M.M.M",
".M.M { k ( J D < r.0 O.4.w.m.M.M",
".M.M ) i g }.e.  X.n.k , '.m.M.M",
".M.M >.a.+ $ _ L Z.# S Q.>.m.M.M",
".M.% ^ - # 6.u 3 j V % ] 0.j.M.M",
".% F.i + + 8 q = e [ n.f b.z.M.M",
".% F v +.=.: 9 B l.- `.2 u p.:.:",
".% F v v.:.O.x U.s c |.v.g W p.:",
".% F.$ K t p A.6.. C x G y.9.p.:",
".% F ; !.: M.t A d.3.l.r & &.p.:",
".M.%.%.%.: I.t w E.o & H Y.8.p.:",
".M.M.M.M.:.q *.d @ o o o R 1.1.:",
".M.M.M.M.<.:.:.:.:.:.:.:.:.:.: a"
};


/* apps/accessories-text-editor.png */
/* XPM */
const char *tango_accessories_text_editor[] = {
/* width height ncolors chars_per_pixel */
"16 16 52 1",
/* colors */
"  c #000000",
". c #B1B1B1",
"X c #705B39",
"o c #9D9D9D",
"O c #C89F64",
"+ c #C4A000",
"@ c #8F8F8F",
"# c #A08457",
"$ c #CFAD71",
"% c #D2AC6A",
"& c #757575",
"* c #EBB13D",
"= c #717171",
"- c #A48757",
"; c #636363",
": c #A08356",
"> c #EEEEEE",
", c #ECECEC",
"< c #EAEAEA",
"1 c #EEEAC6",
"2 c #EDE6C5",
"3 c #DADADA",
"4 c #D6D6D6",
"5 c #CCCCCC",
"6 c #CACACA",
"7 c #C2AB8A",
"8 c #C4C4C4",
"9 c #BCBCBC",
"0 c #B8B8B8",
"q c #B2B2B2",
"w c #AEAEAE",
"e c #F9E8C6",
"r c #EDE5C4",
"t c #4C4226",
"y c #A18355",
"u c #888A85",
"i c #8C8C8C",
"p c #868686",
"a c #6B5736",
"s c #FFFFFF",
"d c #EBEBEB",
"f c #E9E9E9",
"g c #A38555",
"h c #CFAA69",
"j c #CEA668",
"k c #EFEBC7",
"l c #DBDBDB",
"z c #D3D3D3",
"x c #CBCBCB",
"c c #8F5902",
"v c #B7B7B7",
"b c None",
/* pixels */
"bbbbbbbbbbbbbbbb",
"bbb+b+b+b+b+bbbb",
"bb+e+e+e+e+e+bbb",
"bu+*+*+*+*+*+ccb",
"bud+9+0+0+0+c1$c",
"bus,,,,,,,zck%yc",
"busl55555vck%-cb",
"bus,,,,,zc1h:cbb",
"busl555vc2j#cubb",
"bus,,,dcrO-c=ubb",
"busl5x&X7gc@pubb",
"bus,,fctaco4wubb",
"buslx8 c;i63qubb",
"bus,d<<fd<d,qubb",
"bu>qqqqqqq.qqubb",
"buuuuuuuuuuuuubb"
};


/* mimetypes/text-x-generic.png */
/* XPM */
const char *tango_text_x_generic[] = {
/* width height ncolors chars_per_pixel */
"16 16 22 1",
/* colors */
"  c #000000",
". c #EDEDE5",
"X c #999999",
"o c #959595",
"O c #818181",
"+ c #F2F2F2",
"@ c #F0F0F0",
"# c #EEEEEE",
"$ c #ECECEC",
"% c #EAEAEA",
"& c #EDEDE6",
"* c #C8C8C8",
"= c #C6C6C6",
"- c #C4C4C4",
"; c #FFFFFF",
": c #F1F1F1",
"> c #EFEFEF",
", c #EDEDED",
"< c #EBEBEB",
"1 c #C7C7C7",
"2 c #C5C5C5",
"3 c None",
/* pixels */
"XOOOOOOOOOOOO333",
"O;;;;;;;;;;;;O33",
"O;$%%<<<$$,@;O33",
"O;%-22====1@;O33",
"O;%<<$$$,,#@;O33",
"O;<2======1@;O33",
"O;<<$$,,.$#@;O33",
"O;<====##&#@;O33",
"O;$$,,##>>>@;O33",
"O;$===11***@;O33",
"O;$,##>>@:::;O33",
"O;,=11***::+;O33",
"O;,,#>>@@:++;O33",
"O;;;;;;;;;;;;O33",
"oOOOOOOOOOOOOo33",
"3333333333333333"
};


/* mimetypes/x-office-calendar.png */
/* XPM */
const char *tango_x_office_calendar[] = {
/* width height ncolors chars_per_pixel */
"16 16 61 1",
/* colors */
"  c #000000",
". c #686A66",
"X c #646662",
"o c #818485",
"O c #CACAC9",
"+ c #C3C4C2",
"@ c #959798",
"# c #C2C4C4",
"$ c #9B9C9A",
"% c #4D5254",
"& c #3B4042",
"* c #393E40",
"= c #C9C9CA",
"- c #B0B1AE",
"; c #AAABA8",
": c #EEEEEE",
"> c #ECECEC",
", c #E6E6E6",
"< c #E4E4E4",
"1 c #E2E2E2",
"2 c #E0E0E0",
"3 c #939591",
"4 c #D6D6D6",
"5 c #D2D2D2",
"6 c #CDCECD",
"7 c #C8C8C8",
"8 c #FBFBFA",
"9 c #E3E3E2",
"0 c #636561",
"q c #61635F",
"w c #B0B2B3",
"e c #555753",
"r c #898C86",
"t c #888A85",
"y c #4A5052",
"u c #A0A2A3",
"i c #7C7E79",
"p c #C2C3C1",
"a c #404648",
"s c #383E40",
"d c #B8B9B7",
"f c #C8C9CA",
"g c #32383A",
"h c #2E3436",
"j c #4C5153",
"k c #414748",
"l c #FFFFFF",
"z c #FDFDFD",
"x c #C5C6C6",
"c c #F3F3F3",
"v c #F1F1F1",
"b c #E9E9E9",
"n c #E7E7E7",
"m c #E3E3E3",
"M c #E1E1E1",
"N c #DFDFDF",
"B c #D9D9D9",
"V c #CECFCE",
"C c #CACBCA",
"Z c #6E706C",
"A c None",
/* pixels */
"AAttAAAtAAAtAAAA",
"AtttttttttttttAA",
"tlt+llt4zzt4zltA",
"tlt3,,tt9,tt,ltA",
"tl4B,,44<,444ltA",
"il,<fo1jawnn,liA",
"il:,%hN@7y,,VliA",
"il:,NhN#ku,,OliA",
".l,,NhNg=x,6pl.A",
".l,,NhN&*s,6pl.A",
"0l,mm2mMMM5cz80A",
"Xl,b>:v,VCdc-$XA",
"Xlllllllllll;ZXA",
"0qqqqqqqqqqqqqXA",
"AhteeeeeeeeeehAA",
"AhhhhhhhhhhhhhAA"
};


/* places/user-trash.png */
/* XPM */
const char *tango_user_trash[] = {
/* width height ncolors chars_per_pixel */
"16 16 135 2",
/* colors */
"   c #000000",
" . c #6A6C68",
" X c #D6DBC8",
" o c #686A66",
" O c #CCD29D",
" + c #D3D8BB",
" @ c #5E605C",
" # c #A9B260",
" $ c #959E49",
" % c #BCC662",
" & c #8A915C",
" * c #CDD2A1",
" = c #AAB264",
" - c #5D6329",
" ; c #BAC36D",
" : c #B1B4AD",
" > c #7F865E",
" , c #6B6D68",
" < c #545B23",
" 1 c #D4D9BB",
" 2 c #989A94",
" 3 c #D2D7B9",
" 4 c #61635E",
" 5 c #B5BB82",
" 6 c #C3CA89",
" 7 c #A0A956",
" 8 c #CCD19F",
" 9 c #C8CEA5",
" 0 c #A8AD75",
" q c #A1A76E",
" w c #BDC765",
" e c #909946",
" r c #D1D793",
" t c #98A247",
" y c #666D2D",
" u c #B8BE84",
" i c #BDC675",
" p c #939A59",
" a c #494D4C",
" s c #81893A",
" d c #8C9548",
" f c #646663",
" g c #4E541F",
" h c #B2B881",
" j c #B6BBA6",
" k c #9FA46B",
" l c #A5AE49",
" z c #D0D691",
" x c #788134",
" c c #9AA252",
" v c #8C9162",
" b c #929C4A",
" n c #ACB27E",
" m c #545B21",
" M c #797B77",
" N c #757773",
" B c #737571",
" V c #737B32",
" C c #6D6F6B",
" Z c #CAD184",
" A c #C7CC8B",
" S c #919A4C",
" D c #8A9259",
" F c #B8C065",
" G c #767B77",
" H c #D4D9BC",
" J c #636561",
" K c #D3D9BB",
" L c #61682A",
" P c #879042",
" I c #6F7731",
" U c #969F4A",
" Y c #BDC763",
" T c #BBC561",
" R c #9FA956",
" E c #7A8235",
" W c #B5C051",
" Q c #A9B259",
" ! c #ADB17E",
" ~ c #787A75",
" ^ c #798237",
" / c #BCC286",
" ( c #B8C257",
" ) c #CDD590",
" _ c #B7BE81",
" ` c #70726D",
" ' c #575E26",
" ] c #535A22",
" [ c #686A65",
" { c #666863",
" } c #62645F",
" | c #C4CB9E",
".  c #A7AF67",
".. c #A9AD94",
".X c #5C5E59",
".o c #BCC661",
".O c #A8B154",
".+ c #8B9348",
".@ c #CBD09E",
".# c #4C521E",
".$ c #8B943E",
".% c #A5AC72",
".& c #AEB75D",
".* c #ADB75C",
".= c #AAB263",
".- c #565D21",
".; c #A6AF55",
".: c #B2BB64",
".> c #767F33",
"., c #CCD28E",
".< c #B2BD50",
".1 c #C3CA99",
".2 c #5B6129",
".3 c #96A04F",
".4 c #888E69",
".5 c #C9D181",
".6 c #BBC469",
".7 c #BBC55F",
".8 c #B9C35D",
".9 c #899245",
".0 c #6C732F",
".q c #BFC687",
".w c #B3BD5A",
".e c #A3AB72",
".r c #B3BE50",
".t c #98A150",
".y c #C7D07E",
".u c #9CA64D",
".i c #727470",
".p c #DBE0D7",
".a c #70726E",
".s c #C9D18D",
".d c #ADB757",
".f c #949D4F",
".g c None",
/* pixels */
".g.g.g.g.g.g.g.g.g.g.g.g.g.g.g.g",
".g.g < < < < < < < < < < < <.g.g",
".g >.p.p.p.p.p.p.p.p.p.p.p.p.4.g",
" <.p G.X @ 4 J { o , C `.i :.p <",
" <.p a } f [ . C.a B N ~ M 2.p <",
" < j.p.p.p.p.p.p.p.p.p.p.p.p.. <",
" < < p E x.> V I.0 y L -.2 ' < ]",
".g <.y W W.r l.; = t.$ s ^ D <.g",
".g <.y W W.< F X X.@ 7 $ d & <.g",
".g <.5 W W O ;.: 8 * R c.f k <.g",
".g < Z (.o 1 X.* Q # _.t S.% <.g",
".g < z w Y K i.& 9.= 3.3.+ 0 <.g",
".g < r % T.6 *.1 H +.  b.9.e <.g",
".g < ).7.8.w.d.O |.u U e P q <.g",
".g < !.,.s A 6.q / u 5 h n v <.g",
".g.g < < < < < < < < < < < <.g.g"
};


/* apps/utilities-system-monitor.png */
/* XPM */
const char *tango_utilities_system_monitor[] = {
/* width height ncolors chars_per_pixel */
"16 16 116 2",
/* colors */
"   c #000000",
" . c #8199BA",
" X c #DEE0DD",
" o c #EDEAB0",
" O c #F6F8FB",
" + c #F5F8FA",
" @ c #316696",
" # c #4280AD",
" $ c #407EAB",
" % c #316A99",
" & c #7D7D7A",
" * c #2F6697",
" = c #F1F6F9",
" - c #2C6294",
" ; c #3772A2",
" : c #BFCFA0",
" > c #97B893",
" , c #E7E8B0",
" < c #E4E5E2",
" 1 c #E2E3E0",
" 2 c #DFE1DD",
" 3 c #BBC774",
" 4 c #265987",
" 5 c #D7D9D5",
" 6 c #D5D7D3",
" 7 c #4D8DB7",
" 8 c #98C0D9",
" 9 c #CCCFCA",
" 0 c #EEE788",
" q c #4D8FBA",
" w c #D7E5EF",
" e c #3D79A7",
" r c #3D77A7",
" t c #4A8DB7",
" y c #7792B5",
" u c #FEFEFE",
" i c #F9FAF9",
" p c #B6C496",
" a c #829B7A",
" s c #90AF8B",
" d c #89A584",
" f c #85A180",
" g c #E9F1F6",
" h c #C9CCC6",
" j c #5294BE",
" k c #346A9A",
" l c #D8E6EF",
" z c #316697",
" x c #4D8EB9",
" c c #D6E4ED",
" v c #2C6292",
" b c #3A74A3",
" n c #4584B1",
" m c #346E9D",
" M c #B4B6B1",
" N c #316A9A",
" B c #F9F9F8",
" V c #EFF4F8",
" C c #F4F5F3",
" Z c #8CAA86",
" A c #89A483",
" S c #87A481",
" D c #E5E7E4",
" F c #829C7C",
" G c #2C5D8E",
" H c #DCDDDB",
" J c #5495BF",
" K c #BAD1E1",
" L c #4887B3",
" P c #7E7E7B",
" I c #3D7BA8",
" U c #F0F5F8",
" Y c #BECE9F",
" T c #DBDCD9",
" R c #DADCD8",
" E c #D3D6D1",
" W c #D0D2CE",
" Q c #2C6090",
" ! c #CBCEC9",
" ~ c #4280AC",
" ^ c #488AB5",
" / c #3772A1",
" ( c #FFFFFF",
" ) c #34709E",
" _ c #4284AF",
" ` c #346E9E",
" ' c #316C9B",
" ] c #FAFBFA",
" [ c #96B691",
" { c #F8F9F8",
" } c #3D7CAA",
" | c #94B48F",
".  c #F6F7F6",
".. c #93B28E",
".X c #849E7C",
".o c #204A87",
".O c #91B08C",
".+ c #90AE8B",
".@ c #8EAC89",
".# c #8BAA86",
".$ c #D5DBA7",
".% c #D3D9A5",
".& c #85A280",
".* c #D6E3ED",
".= c #3D77A6",
".- c #4587B1",
".; c #4283AE",
".: c #B4B7B1",
".> c #96B590",
"., c #F0F5F9",
".< c #EEEEED",
".1 c #8BA785",
".2 c #BACA9C",
".3 c #E9EAE8",
".4 c #B7C699",
".5 c None",
/* pixels */
" P P P P P P P P P P P P P P P &",
" P B { ( ( ( ( ( ( ( ( u ] ] ] P",
" P B y.o.o.o.o.o.o.o.o.o.o y H P",
" P u.o 4 G - a F ' N % @ v.o D P",
" P u.o Q z.X o.& b b ; ) k.o 1 P",
" P u.o * ` p V.4.1 } I.= /.o X P",
" P u.o m S.% K c.@ n.; $ e.o T P",
" P u.o f d.*.2 w.O 3 s.@.#.o 5 P",
" P u.o + O.$.O l Y 0 =., U.o E P",
" P u.o A Z.+.. : g 8 |.O.@.o W P",
" P u.o r # L x [ , >.> 7 n.o 9 P",
" P u.o.= ~.- t | J j q ^ _.o h P",
" P B ..o.o.o.o.o.o.o.o.o.o y M P",
" P B.  i C.<.3 < 2 R 6 W !.:.: P",
" P P P P P P P P P P P P P P P &",
".5.5.5.5.5.5.5.5.5.5.5.5.5.5.5.5"
};


/* apps/utilities-terminal.png */
/* XPM */
const char *tango_utilities_terminal[] = {
/* width height ncolors chars_per_pixel */
"16 16 163 2",
/* colors */
"   c #000000",
" . c #A0A19D",
" X c #8E9F74",
" o c #8C9D72",
" O c #9A9B97",
" + c #989995",
" @ c #DDDEDC",
" # c #849074",
" $ c #939590",
" % c #D7D8D6",
" & c #8F918C",
" * c #374525",
" = c #8D8F8A",
" - c #CDCECC",
" ; c #81837E",
" : c #E0E3DB",
" > c #ACBC94",
" , c #0A0B09",
" < c #090908",
" 1 c #657C41",
" 2 c #AABA92",
" 3 c #192011",
" 4 c #070706",
" 5 c #4F6332",
" 6 c #ECEDEA",
" 7 c #A5B68D",
" 8 c #B2B4B1",
" 9 c #DBDBD9",
" 0 c #29331D",
" q c #26311A",
" w c #91928D",
" e c #D7D7D5",
" r c #364423",
" t c #555952",
" y c #46572C",
" u c #8B8C87",
" i c #7E807A",
" p c #7D8079",
" a c #6A7559",
" s c #0F100D",
" d c #C0C1BE",
" f c #787C74",
" g c #777A73",
" h c #747870",
" j c #A9B990",
" k c #6A6E66",
" l c #B0B1AE",
" z c #D3D6CD",
" x c #B1BF9B",
" c c #646860",
" v c #5F625B",
" b c #29341C",
" n c #28341B",
" m c #828E70",
" M c #92958D",
" N c #27321A",
" B c #374523",
" V c #8C8F87",
" C c #46562B",
" Z c #888B83",
" A c #989996",
" S c #DDDEDD",
" D c #4E5E36",
" F c #D7D8D7",
" G c #A8B88E",
" H c #A3A69D",
" J c #B4B6B1",
" K c #AFBE98",
" L c #F2F3F1",
" P c #747772",
" I c #768560",
" U c #536537",
" Y c #182011",
" T c #060706",
" R c #3C4C27",
" E c #4E6132",
" W c #3B4A26",
" Q c #4C5A3A",
" ! c #273119",
" ~ c #020302",
" ^ c #808D6D",
" / c #343633",
" ( c #90A076",
" ) c #CFD3CB",
" _ c #DDDDDC",
" ` c #969893",
" ' c #616A55",
" ] c #4C563D",
" [ c #94A27D",
" { c #D6D7D5",
" } c #8A8C87",
" | c #657152",
".  c #647151",
".. c #CCCDCB",
".X c #848681",
".o c #131412",
".O c #A2B387",
".+ c #0D0E0C",
".@ c #0B0C0A",
".# c #080807",
".$ c #070806",
".% c #758954",
".& c #4F6232",
".* c #D9DED4",
".= c #7F8C6B",
".- c #2F312D",
".; c #636660",
".: c #73825F",
".> c #27321B",
"., c #5A5E57",
".< c #364523",
".1 c #364323",
".2 c #545851",
".3 c #878983",
".4 c #868782",
".5 c #616E4D",
".6 c #82857E",
".7 c #81837D",
".8 c #7E817A",
".9 c #7D7F79",
".0 c #797D75",
".q c #7A846C",
".w c #767972",
".e c #6F736B",
".r c #A3A69E",
".t c #7E8B69",
".y c #7C8967",
".u c #9DA098",
".i c #798764",
".p c #656961",
".a c #999C94",
".s c #CED1C8",
".d c #99A38A",
".f c #62655E",
".g c #979A92",
".h c #859869",
".j c #29351C",
".k c #3B4A27",
".l c #28331B",
".z c #27311A",
".x c #92A279",
".c c #8D9088",
".v c #878A82",
".b c #97A681",
".n c #83867E",
".m c #95A47F",
".M c #232423",
".N c #737D64",
".B c #B7B9B4",
".V c #A4B58A",
".C c #A2A59C",
".Z c #7B8865",
".A c #697850",
".S c #AEBD97",
".D c #CDD2C6",
".F c #181F11",
".G c #060606",
".H c #849071",
".J c #3C4B27",
".K c #28321A",
".L c #273019",
".P c #010201",
".I c None",
/* pixels */
".I.u.a M.c Z.n.8.0 h.e k.p.f.,.I",
" H J e S @ _ _ _ _ _ _ 9.. 8 P t",
" H { /.#.#.#.#.#.#.#.# 4 4.- A t",
".C F s x K.S > 2 j G 7.V.O   O.2",
".C F.+ #.H m ^.=.t.y.Z.i I   `.2",
".C F.@.b.m [.x ( X o.h.% 1   $.2",
".C F , a.*.q |. .5 D C C y   w.2",
".C F <.:.d :.D.A U E.&.& 5   =.2",
".C F.$ ] ' ) z *.1 r r.< B   }.2",
".C F 4 Q.s.N.k W W W.J.J R  .3.2",
".C F 4 0.z.L ! L L L 6.K.K  .X.2",
".C F T q N.>.>.l.l n b b.j  .7.2",
".C F.G.F.F.F.F.F.F.F Y 3 3   i.2",
" H %.M ~.P.P.P.P.P.P.P.P.P.o.w t",
".r.B - d l . + $ & u.4 ;.9 g.; t",
".I.u.g M V.v.6 p f h.e k c v.,.I"
};


/* status/weather-clear.png */
/* XPM */
const char *tango_weather_clear[] = {
/* width height ncolors chars_per_pixel */
"16 16 82 1",
/* colors */
"  c #000000",
". c #FBBD5B",
"X c #FDF4AC",
"o c #FCF4AB",
"O c #FDF3A2",
"+ c #FEFCEF",
"@ c #FCB23E",
"# c #FCB03E",
"$ c #FBAE3D",
"% c #FBB94A",
"& c #FCE34E",
"* c #FAB43F",
"= c #FCEB65",
"- c #FBBA57",
"; c #FCE768",
": c #FCEF82",
"> c #FEF8D0",
", c #FEFEFB",
"< c #FBB13F",
"1 c #FDCD83",
"2 c #FEF8E7",
"3 c #FDF5B1",
"4 c #FCED71",
"5 c #FDF6BE",
"6 c #FCE55D",
"7 c #FCD549",
"8 c #FDE6C1",
"9 c #FEF9CF",
"0 c #FDEAAD",
"q c #FEFCF0",
"w c #FCB43F",
"e c #FCB23F",
"r c #FDF4B0",
"t c #FCE459",
"y c #FCC66D",
"u c #FCC470",
"i c #FDF08B",
"p c #FEF8CE",
"a c #FDF0A2",
"s c #FBC168",
"d c #FCB33E",
"f c #FCB13E",
"g c #FCAF3E",
"h c #FBAF3D",
"j c #FBC16E",
"k c #FCEC68",
"l c #FDE6BF",
"z c #FDF3A1",
"x c #FAB545",
"c c #FBD349",
"v c #FCEA57",
"b c #FDF4AE",
"n c #FCF4AD",
"m c #FEF9D0",
"M c #FEFCF1",
"N c #FCE86E",
"B c #FBB43F",
"V c #FEF9E7",
"C c #FCCC82",
"Z c #FBAE3F",
"A c #FCEA5A",
"S c #FCBC57",
"D c #FCD964",
"F c #FDF089",
"G c #FDECB4",
"H c #FDF1AA",
"J c #FDF08C",
"K c #FEFAE3",
"L c #FCE956",
"P c #FCEF81",
"I c #FCB953",
"U c #FEFDF0",
"Y c #FCB33F",
"T c #FBB13E",
"R c #FBDB6C",
"E c #FCE959",
"W c #FCEF84",
"Q c #FCCD84",
"! c #FEF9DF",
"~ c #FCEF87",
"^ c #FCC570",
"/ c None",
/* pixels */
"////////////////",
"///////#f///////",
"///////ff///////",
"///ge/1CuI/@g///",
"///@ylVq!0-Ye///",
"////8,+prnax////",
"///12UU9XF~Dd///",
"/ffQM>m5zPk;Tf#/",
"/#f^K3bOJ4Et<ff/",
"///SGoi:4Avce///",
"////.HW=Lv&*////",
"///ew%RN67Bd@///",
"///g@/e<Td/eg///",
"///////ff///////",
"///////f#///////",
"////////////////"
};


/* XPM */
const char *tango48_dialog_information[] = {
/* width height ncolors chars_per_pixel */
"48 48 678 2",
/* colors */
"   c #000000",
" . c #626674",
" X c #8C895B",
" o c #BACDE8",
" O c #7F8697",
" + c #B8CDE6",
" @ c #DCE1E5",
" # c #D1DFEE",
" $ c #9BB9DA",
" % c #ACAA77",
" & c #D0DDED",
" * c #F0F0F2",
" = c #B4CBE2",
" - c #CFDDEC",
" ; c #C9CDCF",
" : c #A9A9A9",
" > c #B4C9E2",
" , c #7DA3CD",
" < c #C5C7A0",
" 1 c #D8DAAC",
" 2 c #A7A472",
" 3 c #C6D6ED",
" 4 c #ABC2E3",
" 5 c #C5D4EC",
" 6 c #717168",
" 7 c #8EAED7",
" 8 c #C3D4EA",
" 9 c #BDC4CD",
" 0 c #BCBEA1",
" q c #F7FAFC",
" w c #DCE6F2",
" e c #DDE4F3",
" r c #A2AEC3",
" t c #626677",
" y c #505037",
" u c #C0D2E7",
" i c #616676",
" p c #DBE4F1",
" a c #BFD2E6",
" s c #868997",
" d c #89ACD2",
" f c #D9E4EF",
" g c #88ACD1",
" h c #85A7D8",
" j c #848795",
" k c #63636E",
" l c #A4A686",
" z c #4A4A31",
" x c #DFE0E1",
" c c #B4C9E5",
" v c #EEF0F3",
" b c #EAEDF9",
" n c #7EA3D1",
" m c #B3C9E4",
" M c #4B4B28",
" N c #C6CDCF",
" B c #CCDBEC",
" V c #CBDBEB",
" C c #CBD9EB",
" Z c #AFC7E0",
" A c #CAD9EA",
" S c #E4EDF3",
" D c #EBEDBB",
" F c #AEC5DF",
" G c #1A1A0F",
" H c #9EB1CC",
" J c #E9EBB9",
" K c #C4C698",
" L c #DBDC9E",
" P c #A7C0E2",
" I c #E7E9B7",
" U c #C2C496",
" Y c #686841",
" T c #A8A862",
" R c #8BACD7",
" E c #A0A499",
" W c #8D8D8D",
" Q c #F4F7C7",
" ! c #D7E4F0",
" ~ c #9EA497",
" ^ c #626570",
" / c #D7E2F0",
" ( c #E5E7E0",
" ) c #D6E2EF",
" _ c #F0F4F8",
" ` c #9FBCDA",
" ' c #9FBADA",
" ] c #B6C9EA",
" [ c #83A8CF",
" { c #4D4D2D",
" } c #73767A",
" | c #A7ABAD",
".  c #799ED9",
".. c #DBDEE0",
".X c #ECEEF4",
".o c #B7BA8B",
".O c #E4EDF6",
".+ c #C8D9EB",
".@ c #84887A",
".# c #57573A",
".$ c #C7D9EA",
".% c #E2EBF4",
".& c #C7D7EA",
".* c #C6D7E9",
".= c #8FB1D4",
".- c #AAC3DE",
".; c #C5D5E8",
".: c #8FAFD4",
".> c #656976",
"., c #B9C4CF",
".< c #7098D0",
".1 c #636774",
".2 c #C0C2C2",
".3 c #616572",
".4 c #606371",
".5 c #D5E0F1",
".6 c #9EBADC",
".7 c #777777",
".8 c #D2E0EE",
".9 c #D1DEED",
".0 c #B6CAE3",
".q c #7FA4CE",
".w c #F8FADB",
".e c #B2B7BE",
".r c #727C93",
".t c #C8CDC3",
".y c #CBD6E7",
".u c #B5B782",
".i c #A7BEE8",
".p c #8FAFD7",
".a c #C4D5EA",
".s c #DEE9F3",
".d c #7098D3",
".f c #6D6D6D",
".g c #DDE7F2",
".h c #A7C1DE",
".j c #C2D3E8",
".k c #DDE5F2",
".l c #F7F9FB",
".z c #C1D3E7",
".x c #8BADD3",
".c c #616775",
".v c #3F3F22",
".b c #616575",
".n c #606574",
".m c #9C9C70",
".M c #A3A359",
".N c #4B4B31",
".B c #515123",
".V c #F0F1F4",
".C c #D5D7BF",
".Z c #CEDEED",
".A c #4C4C28",
".S c #CDDCEC",
".D c #CCDAEB",
".F c #ECEDF0",
".G c #B0C8E0",
".H c #CBDAEA",
".J c #7AA2CC",
".K c #95B4D6",
".L c #6B6E78",
".P c #98AED9",
".I c #C6D5EF",
".U c #79A0CB",
".Y c #B2C5D8",
".T c #6F98D5",
".R c #5B5B5B",
".E c #BABFA1",
".W c #ABAC5A",
".Q c #7099CC",
".! c #595959",
".~ c #DAE5F2",
".^ c #86A8DB",
"./ c #D9E5F1",
".( c #ABBCDB",
".) c #A3BFDD",
"._ c #BDD1E6",
".` c #D8E3F0",
".' c #A2BDDC",
".] c #80A3DF",
".[ c #D7E3EF",
".{ c #A1BDDB",
".} c #F1F5F8",
".| c #606042",
"X  c #555555",
"X. c #D6E1EE",
"XX c #91927C",
"Xo c #F2F4C4",
"XO c #686A61",
"X+ c #F1F4C3",
"X@ c #535353",
"X# c #83A7CE",
"X$ c #555580",
"X% c #858459",
"X& c #7A9FD9",
"X* c #CDCE99",
"X= c #7D8290",
"X- c #D2D5BF",
"X; c #EBEEBD",
"X: c #84854E",
"X> c #C9DAEB",
"X, c #C9D8EB",
"X< c #929494",
"X1 c #C8D8EA",
"X2 c #696C79",
"X3 c #464625",
"X4 c #C7D8E9",
"X5 c #E2EAF3",
"X6 c #91B2D5",
"X7 c #ACC4DF",
"X8 c #C0C2A0",
"X9 c #C6D6E8",
"X0 c #759ECA",
"Xq c #474747",
"Xw c #636673",
"Xe c #626672",
"Xr c #96977A",
"Xt c #A8A85A",
"Xy c #616471",
"Xu c #EFF5F9",
"Xi c #BEBE8A",
"Xp c #9CB9D9",
"Xa c #B7CBE3",
"Xs c #D4D68F",
"Xd c #81A5CF",
"Xf c #9BB9D8",
"Xg c #80A5CE",
"Xh c #F0F0F0",
"Xj c #555744",
"Xk c #BFC3AC",
"Xl c #A4AFA2",
"Xz c #AFC6E5",
"Xx c #96AEDD",
"Xc c #686C7B",
"Xv c #676C7A",
"Xb c #A6AC9A",
"Xn c #DCDFCF",
"Xm c #C4D6E9",
"XM c #D9DBA1",
"XN c #DDE8F1",
"XB c #636876",
"XV c #C1D4E6",
"XC c #8BAED2",
"XZ c #C1D2E6",
"XA c #626675",
"XS c #9FB8E9",
"XD c #DBE4EF",
"XF c #A1A495",
"XG c #52512D",
"XH c #313131",
"XJ c #75744C",
"XK c #6C7282",
"XL c #EBF1F8",
"XP c #CFDFED",
"XI c #DADFE4",
"XU c #CFDDED",
"XY c #CEDDEC",
"XT c #98B7D8",
"XR c #B3C9E2",
"XE c #97B7D7",
"XW c #CDDBEB",
"XQ c #96B5D6",
"X! c #494924",
"X~ c #749CCF",
"X^ c #81837C",
"X/ c #BCC6CD",
"X( c #626878",
"X) c #DBE6F2",
"X_ c #C6CBB9",
"X` c #BFD2E7",
"X' c #DFE5EC",
"X] c #A4BEDD",
"X[ c #BED2E6",
"X{ c #A3BEDC",
"X} c #D8E4EF",
"X| c #51512F",
"o  c #B9CBEB",
"o. c #828594",
"oX c #F1F3C2",
"oo c #EAEDFA",
"oO c #DDDFAB",
"o+ c #E6EDF6",
"o@ c #5D5E34",
"o# c #CBD9EC",
"o$ c #CAD9EB",
"o% c #EBEDBC",
"o& c #AEC7E0",
"o* c #B6B688",
"o= c #C9D9EA",
"o- c #8DABE4",
"o; c #AEC5E0",
"o: c #C8D9E9",
"o> c #E6EAEC",
"o, c #E5E8EB",
"o< c #C0C3CA",
"o1 c #646773",
"o2 c #9EB9E4",
"o3 c #626571",
"o4 c #BFC4BF",
"o5 c #C0C0C0",
"o6 c #60656F",
"o7 c #D5E2EF",
"o8 c #9FBCDB",
"o9 c #D4E0EE",
"o0 c #C9CFD6",
"oq c #C5CCDC",
"ow c #9EBADA",
"oe c #D7DFE7",
"or c #9BB8D7",
"ot c #848785",
"oy c #AEBCC2",
"ou c #7E8289",
"oi c #BAB985",
"op c #95ADDB",
"oa c #E3E9F6",
"os c #E2E9F5",
"od c #C6D7EA",
"of c #303018",
"og c #B2BAB2",
"oh c #E0E9F3",
"oj c #6C7995",
"ok c #AAC3DF",
"ol c #DFE9F2",
"oz c #879AC0",
"ox c #7D817E",
"oc c #C4D5E8",
"ov c #DEE9F1",
"ob c #AAB0BE",
"on c #C3D5E7",
"om c #DEE7F1",
"oM c #85A7DF",
"oN c #626774",
"oB c #B0B0B0",
"oV c #616573",
"oC c #616373",
"oZ c #D5E0F2",
"oA c #EDEECE",
"oS c #9AB5E3",
"oD c #D1E0EE",
"oF c #72747D",
"oG c #B6CCE4",
"oH c #D1DEEE",
"oJ c #D0DEED",
"oK c #CFDEEC",
"oL c #B3B595",
"oP c #CFDCEC",
"oI c #8F94A0",
"oU c #B3CAE1",
"oY c #B4B461",
"oT c #98B6D7",
"oR c #B2CAE0",
"oE c #B3C8E1",
"oW c #D8DCE1",
"oQ c #57573E",
"o! c #A1A276",
"o~ c #DEE9F4",
"o^ c #D5D7A9",
"o/ c #F3F4D7",
"o( c #DCE7F2",
"o) c #8999BB",
"o_ c #626777",
"o` c #BFD1E6",
"o' c #89ABD2",
"o] c #51522E",
"o[ c #64646F",
"o{ c #A2BDDA",
"o} c #DCE4E8",
"o| c #9C9C9C",
"O  c #9FB6E1",
"O. c #ECEEFB",
"OX c #808491",
"Oo c #C4C7AC",
"OO c #EEF1F3",
"O+ c #4C4C29",
"O@ c #A0B3D8",
"O# c #D8DCE4",
"O$ c #C3C9D6",
"O% c #C9CB9D",
"O& c #CCDCEC",
"O* c #686D80",
"O= c #CCDAEC",
"O- c #CBDAEB",
"O; c #9B9E87",
"O: c #CADAEA",
"O> c #E5ECF4",
"O, c #94B4D6",
"O< c #AFC6E0",
"O1 c #919266",
"O2 c #94B2D6",
"O3 c #E4EAF3",
"O4 c #5B5B31",
"O5 c #78A0CB",
"O6 c #59592F",
"O7 c #E3E6F2",
"O8 c #E6E8B6",
"O9 c #C8CBB3",
"O0 c #F2F5FA",
"Oq c #61666F",
"Ow c #F1F5F9",
"Oe c #D6E1EF",
"Or c #9CB8E1",
"Ot c #D5E1EE",
"Oy c #9FBBDA",
"Ou c #CCD1CE",
"Oi c #E9EEFB",
"Op c #CDCE9A",
"Oa c #BDBC87",
"Os c #E8ECFA",
"Od c #878B7D",
"Of c #769DD6",
"Og c #CACA97",
"Oh c #C9D8EC",
"Oj c #C8D8EB",
"Ok c #C7D8EA",
"Ol c #949162",
"Oz c #C8C895",
"Ox c #E1EAF3",
"Oc c #595932",
"Ov c #C6D6E9",
"Ob c #E0EAF2",
"On c #9B9B80",
"Om c #BBC3D1",
"OM c #8FB0D4",
"ON c #666677",
"OB c #424222",
"OV c #646875",
"OC c #8DAED2",
"OZ c #919480",
"OA c #616472",
"OS c #D3E1EF",
"OD c #646436",
"OF c #D4DDF0",
"OG c #D2DFEE",
"OH c #EDF1F8",
"OJ c #D1DFED",
"OK c #99976A",
"OL c #B6CBE3",
"OP c #D0DDEC",
"OI c #9AB7D8",
"OU c #CFDDEB",
"OY c #7BA0D4",
"OT c #A8B09D",
"OR c #759BD8",
"OE c #8890A2",
"OW c #C6C9CB",
"OQ c #8EADE0",
"O! c #98ADD6",
"O~ c #9FA4A8",
"O^ c #7D8AAB",
"O/ c #F4F5D7",
"O( c #DEE8F3",
"O) c #ABBEE2",
"O_ c #DDE8F2",
"O` c #7E8BA2",
"O' c #F2F3D5",
"O] c #636877",
"O[ c #C1D4E7",
"O{ c #626876",
"O} c #F6FAFA",
"O| c #C1D2E7",
"+  c #626676",
"+. c #DBE6F0",
"+X c #9FB8EA",
"+o c #8AAED2",
"+O c #626276",
"++ c #686868",
"+@ c #8B895C",
"+# c #3C3C1F",
"+$ c #828592",
"+% c #888559",
"+& c #B1B9CA",
"+* c #EAF1F8",
"+= c #4D4D29",
"+- c #CEDDED",
"+; c #606035",
"+: c #B9C8DF",
"+> c #CDDBEC",
"+, c #CCDBEB",
"+< c #CBDBEA",
"+1 c #666C7D",
"+2 c #94B3D5",
"+3 c #6B6A43",
"+4 c #E8EAEC",
"+5 c #E2E9F0",
"+6 c #626879",
"+7 c #93A9D4",
"+8 c #DAE6F2",
"+9 c #535332",
"+0 c #8C8B60",
"+q c #585858",
"+w c #5D6874",
"+e c #292916",
"+r c #D8E4F0",
"+t c #F4F7C6",
"+y c #BDD0E6",
"+u c #9B9972",
"+i c #65643D",
"+p c #3C3C22",
"+a c #BCD0E5",
"+s c #565656",
"+d c #636370",
"+f c #61656E",
"+g c #D6E2EE",
"+h c #85A8D0",
"+j c #BACEE3",
"+k c #80A5D5",
"+l c #E8EDF9",
"+z c #B8BA8B",
"+x c #505050",
"+c c #CDD9EF",
"+v c #6C6F7C",
"+b c #8CA2C3",
"+n c #E7EBF8",
"+m c #B4B9BC",
"+M c #CAD9EC",
"+N c #FFFFFF",
"+B c #AFC5E2",
"+V c #C9D9EB",
"+C c #C8D9EA",
"+Z c #B1B38E",
"+A c #939460",
"+S c #E2EBF3",
"+D c #92B1D6",
"+F c #ACC5DF",
"+G c #C7D7E9",
"+H c #E2E9F3",
"+J c #B8C3D7",
"+K c #D6D8DA",
"+L c #90B1D4",
"+P c #80804A",
"+I c #CFD5DD",
"+U c #56562E",
"+Y c #464646",
"+T c #7A7D79",
"+R c #636373",
"+E c #616571",
"+W c #606370",
"+Q c #B9CEE5",
"+! c #D4E0EF",
"+~ c #DEE2E5",
"+^ c #83A8D1",
"+/ c #9EBADB",
"+( c #D3E0EE",
"+) c #EEF2F8",
"+_ c #798499",
"+` c #9DBADA",
"+' c #D2E0ED",
"+] c #96B2E7",
"+[ c #B6CCE2",
"+{ c #71747A",
"+} c #909074",
"+| c #80A4CE",
"@  c #7CA1D4",
"@. c #E6EBFA",
"@X c #B4B45F",
"@o c #474729",
"@O c #99B2D6",
"@+ c #ACC3E2",
"@@ c #E0E9F4",
"@# c #E5EAEF",
"@$ c #D6D9A8",
"@% c #C4D5E9",
"@& c #A1A074",
"@* c #F9FBFC",
"@= c #C3D5E8",
"@- c #646977",
"@; c #DDE7F1",
"@: c #A7C1DD",
"@> c #C2D3E7",
"@, c #636776",
"@< c #719BC9",
"@1 c #8CADD3",
"@2 c #626775",
"@3 c #8D9AB3",
"@4 c #C1CFE6",
"@5 c #A1BAE1",
"@6 c #F4F5F7",
"@7 c #64646D",
"@8 c #EDEECF",
"@9 c #9A9A6D",
"@0 c #B8CCE7",
"@q c #F2F3F5",
"@w c #D1DEEF",
"@e c #4E4E29",
"@r c #C7CBD8",
"@t c #D0DEEE",
"@y c #CFDEED",
"@u c #ACAFA3",
"@i c #99B6D9",
"@p c #6A6F80",
"@a c #CEDCEC",
"@s c #EAECF7",
"@d c #CDDCEB",
"@f c #2C2C2C",
"@g c #759CDA",
"@h c #7CA2CD",
"@j c #BCC6D7",
"@k c #B3B6B7",
"@l c #8199C8",
"@z c #BCC5CD",
"@x c #DEE5F5",
"@c c #C2C4C9",
"@v c #626778",
"@b c #DBE7F2",
"@n c #616777",
"@m c #DBE5F2",
"@M c #DAE5F1",
"@N c #AABED9",
"@B c #F5F8C6",
"@V c #BED1E6",
"@C c #D9E3F0",
"@Z c #646470",
"@A c #BDCFE5",
"@S c #B0C0CB",
"@D c #BBCFE3",
"@F c #F1F4C2",
"@G c #DFE1E2",
"@H c #D0DCF1",
"@J c #EFF1F5",
"@K c #E8F2F8",
"@L c #EFF2C0",
"@P c #1C1C1C",
"@I c #DDDFE0",
"@U c #DEE0AC",
"@Y c #E8EEF8",
"@T c #D6D8B8",
"@R c #CCDCED",
"@E c #1A1A1A",
"@W c #92A2BE",
"@Q c #B2C4E4",
"@! c #E6ECF6",
"@~ c #B0C6E2",
"@^ c #CADAEB",
"@/ c #CFDBE6",
"@( c #CAD8EB",
"@) c #AEC6E0",
"@_ c #C8D8E9",
"@` c #DCE5F6",
"@' c #6F778B",
"@] c #F2F7FB",
"@[ c #F3F6C7",
"@{ c #D6E3F0",
"@} c #626471",
"@| c #B2BCD0",
"#  c #D6E1F0",
"#. c #626271",
"#X c #E0E3E6",
"#o c #D5E1EF",
"#O c #6B7387",
"#+ c #D4E1EE",
"#@ c #98B3E8",
"## c #EFF3F8",
"#$ c #515128",
"#% c #9EBBDA",
"#& c #B9CDE4",
"#* c #9B996A",
"#= c #B8CDE3",
"#- c #D3DFED",
"#; c #CED09C",
"#: c #CCCFCF",
"#> c #6B707D",
"#, c #ADC3EC",
"#< c #B9B9B9",
"#1 c #CAD8EE",
"#2 c #686C7A",
"#3 c #E2EAF5",
"#4 c #ACC4E1",
"#5 c #AFB28E",
"#6 c #C6D6EA",
"#7 c #C5D6E9",
"#8 c #B1C1DC",
"#9 c #C4D6E8",
"#0 c #DFE8F2",
"#q c #A9C2DE",
"#w c #8DAED3",
"#e c #C2D4E6",
"#r c #DDE6F0",
"#t c None",
/* pixels */
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t.b+6o_oVoVo_+6.c#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t@n#Oo)O@O) ]o @Q.(@W@'@n#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t@2O*O!#,oS.^@ X~X~ n R P.I#8XK@2#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tXAO^.iOQ.d+k.p+/o;oG+F.'@1X0.6+c@3XA#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t+1+7XS.  h c.*.&X1Ok.&+GOv.;o`.: [ 5+:@p#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t iopo-X& 4#6X4.$X1o=+CX1X1+GX9oc@AXdO5@+@4+ #t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t+ @l#@OR oodOk.&o=o= A@^o$@^o=Ok#7@=X7 ,.U 3 H+ #t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#toj+X@gXz.a.*+GX1 C@^ B B B VO:o=@_X9.z+h.q+h@`+_#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t .Xx.]Or 8Xm#7X4+VO-O=XW@a.S@d+>.D A.&#7XQ+^+|owOF.1#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t.r+].T@0O[@%X4+C@^+,oPoK &.9XU+-@aO&X,Ok.{ d+h+|@HOE#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#tX(ozoMOYX`.j#9.*X>XWXY &oJoD.8OJ.9OP -.So: $OMXC+h@~+JO{#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t@v.POf 7@VO[#7X1.H@a@yOJ#-o9#+OtOtOGoJXU.*XTO,.=+o+D e@,#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#tXAO .<+Lo`@>#6+VO-@y ##-#o )@{ / /# .8 # u 'orO,OMo'OsoN#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t.1o2.QX# a@=.* A.S@t+(#o /@C@M./ fX}X.OU@).)OyOIO2OC@..>#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#toV@5@<O5+aonOv@^@a+'+!.`@M w@bo(@;@M+r@Do&.-.)#%oTX6OiXw#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t t@O@h.Jow@=.&O- &+(Oe./X)XN.sol.gO_O:#&oU Z#qX{XpX]@x@2#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#tX(+b.x ,+hXaX4 B.9+(.[+.O(Obos+H.~X,O[X[+joUo;@:o8 +.yO]#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#tO`@iXg gO,.Goc.l _Ox#r#0O(+8+'#t#toW x._#=oRX7.)#1+&Xe#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#tXc@No'XC+2XfX{##.}@*@6@#X'o}O# @+4 *o>@=+y+[O<ok@.o.#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t O+B#w.K+`.hoH+)XZXD vOO.VXh.F+~@qO>#tXV+QXRoZO$XB#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t@2 r#4XE `#q.0Xu+<#t#t#t#t#t#t#t q#t#tXmX[Oh+n#>#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#tXv@| mo{X7 =oh p#t#t#t#t#t#tOwO0#t#t#t@wooOX#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#2@joE FOLXP+5#t#t#t#t#t#t@J#t#t#t#tO.+$#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tX=o#o;+[#e+I#t#t#t#t#t#t+K#t#t#toa@r#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t@-oq >#&O[@z 9#t#t#t#t#t#t#t#t#t+l j#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tobO|#&XV.,O~#t#t#t#tX<#t#t#t#t b+v#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t s.5.Y@SoyoxXboL#5On 6#t#t#t#3O7o1#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tOVOmX/XlOT.@OZ.EX8Xr+}+Z l E@soI#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tX2o0 Nog ~OdXkOoO; 0@T.C@Go<OV#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tXj.L.eXIOu.tX_O9X-Xn (.X |+f#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tOD T+Tou+m ;..o,@I#:@koFXO {#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t+U.MXs <XFot+{o1 }X^XX+u X+=#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t.AX:XMO'XoX+o% IoOOpOaOK+3O+#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t+;@XoA+N.w@B@F J@UOz.m+0+i.A#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tO6Xt LO/@[+tX;o^ Uo*oi 2+@+=#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t M+PXMo/X+X+ DO8oOX*Oa#*XJO+#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#to@oY@8+N.w@BoX J@UOg@&@9Olo]#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tO4.W LO/ Q@B@L 1 K+zXi %+%XG#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tX3Oc+A.u#;@$O%.oo!O1X% Y@e#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t.v.NoQ.|+9X|.# y z+##t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t.R#<o5oB W+s#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tX@.7 :o|+++x#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#tXq.!+q+Y#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t",
"#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t#t"
};


/* XPM */
const char *tango48_dialog_warning[] = {
/* width height ncolors chars_per_pixel */
"48 48 307 2",
/* colors */
"   c #000000",
" . c #BB1D1D",
" X c #E6CECE",
" o c #D94141",
" O c #D01414",
" + c #CF2A2A",
" @ c #DBACAC",
" # c #DF6161",
" $ c #CD0707",
" % c #A5A5A5",
" & c #110000",
" * c #DA4545",
" = c #DCD1D1",
" - c #D55757",
" ; c #D46D6D",
" : c #A30505",
" > c #999999",
" , c #E06565",
" < c #D73838",
" 1 c #979797",
" 2 c #DBC6C6",
" 3 c #9F0101",
" 4 c #D21C1C",
" 5 c #DFD7D7",
" 6 c #CA3535",
" 7 c #940000",
" 8 c #DA5F5F",
" 9 c #D85D5D",
" 0 c #8D8D8D",
" q c #800000",
" w c #B31B1B",
" e c #D02727",
" r c #D83C3C",
" t c #CF0F0F",
" y c #C02B2B",
" u c #C84040",
" i c #D43838",
" p c #A50000",
" a c #7F7F7F",
" s c #910000",
" d c #DE5C5C",
" f c #D52F2F",
" g c #CC0202",
" h c #7D7D7D",
" j c #D94040",
" k c #D01313",
" l c #DCB6B6",
" z c #ECE0E0",
" x c #CE1111",
" c c #777777",
" v c #690000",
" b c #DFDDDD",
" n c #A20000",
" m c #DF6060",
" M c #D63333",
" N c #CD0606",
" B c #B72525",
" V c #B52323",
" C c #D02D2D",
" Z c #E16F6F",
" A c #D75858",
" S c #676767",
" D c #BE2F2F",
" F c #636363",
" G c #E4C4C4",
" H c #E06464",
" J c #D73737",
" K c #CE0A0A",
" L c #A10202",
" P c #D53535",
" I c #9F0000",
" U c #C53939",
" Y c #AC1010",
" T c #D13131",
" R c #5B5B5B",
" E c #A80C0C",
" W c #E1B7B7",
" Q c #C42E2E",
" ! c #DB5555",
" ~ c #A40808",
" ^ c #CF0E0E",
" / c #4F4F4F",
" ( c #BC2626",
" ) c #DB6262",
" _ c #9C0000",
" ` c #4B4B4B",
" ' c #DE5B5B",
" ] c #D52E2E",
" [ c #CC0101",
" { c #D78C8C",
" } c #474747",
" | c #B21C1C",
".  c #434343",
".. c #D85555",
".X c #E06A6A",
".o c #D88383",
".O c #DF8080",
".+ c #E1DEDE",
".@ c #F0F0F0",
".# c #D56969",
".$ c #D45151",
".% c #DB4E4E",
".& c #AC1616",
".* c #EEEEEE",
".= c #D13737",
".- c #ECECEC",
".; c #990000",
".: c #CE1D1D",
".> c #DF5F5F",
"., c #D63232",
".< c #CD0505",
".1 c #DAC0C0",
".2 c #EAEAEA",
".3 c #E8E8E8",
".4 c #AB0B0B",
".5 c #DED1D1",
".6 c #850000",
".7 c #E6E6E6",
".8 c #E16E6E",
".9 c #E4E4E4",
".0 c #E2E2E2",
".q c #D9B5B5",
".w c #E0E0E0",
".e c #BC2C2C",
".r c #AA0000",
".t c #DEDEDE",
".y c #D03939",
".u c #D84E4E",
".i c #CE0909",
".p c #A10101",
".a c #B01313",
".s c #DCDCDC",
".d c #EEE7E7",
".f c #D01818",
".g c #CE1616",
".h c #A80B0B",
".j c #DD5656",
".k c #D83A3A",
".l c #CD0B0B",
".z c #A00303",
".x c #E9D8D8",
".c c #DD6363",
".v c #D34C4C",
".b c #171717",
".n c #C12020",
".m c #0D0000",
".M c #C6C6C6",
".N c #D52D2D",
".B c #CC0000",
".V c #D24141",
".C c #DA5656",
".Z c #E06969",
".A c #D65252",
".S c #E1DDDD",
".D c #DB4D4D",
".F c #D22020",
".G c #D24E4E",
".H c #AA1313",
".J c #DF5E5E",
".K c #CD0404",
".L c #CE4A4A",
".P c #010101",
".I c #DC7272",
".U c #B31F1F",
".Y c #DC5151",
".T c #D32424",
".R c #AD1919",
".E c #DFC7C7",
".W c #D23A3A",
".Q c #BA2929",
".! c #D15050",
".~ c #E06262",
".^ c #D73535",
"./ c #A10000",
".( c #CE1515",
".) c #DD5555",
"._ c #D42828",
".` c #FF0000",
".' c #D45656",
".] c #989898",
".[ c #CD0A0A",
".{ c #A00202",
".} c #CD3838",
".| c #9E0000",
"X  c #D46363",
"X. c #DB6060",
"XX c #DA4848",
"Xo c #D11B1B",
"XO c #DDBEBE",
"X+ c #D14949",
"X@ c #A90E0E",
"X# c #C73232",
"X$ c #DE5959",
"X% c #A70C0C",
"X& c #8C8C8C",
"X* c #DD9D9D",
"X= c #DBC9C9",
"X- c #DB4C4C",
"X; c #D21F1F",
"X: c #AA1212",
"X> c #DA9090",
"X, c #808080",
"X< c #D04B4B",
"X1 c #DF5D5D",
"X2 c #D63030",
"X3 c #CD0303",
"X4 c #E16C6C",
"X5 c #DF6A6A",
"X6 c #CD1010",
"X7 c #E2E0E0",
"X8 c #DC5050",
"X9 c #747474",
"X0 c #D35151",
"Xq c #BA2828",
"Xw c #D96464",
"Xe c #CC0505",
"Xr c #6E6E6E",
"Xt c #D33030",
"Xy c #D35E5E",
"Xu c #D94343",
"Xi c #686868",
"Xp c #D65757",
"Xa c #DD5454",
"Xs c #D42727",
"Xd c #A60707",
"Xf c #D33D3D",
"Xg c #DB5252",
"Xh c #A40505",
"Xj c #B31717",
"Xk c #A20303",
"Xl c #A00101",
"Xz c #D11A1A",
"Xx c #5A5A5A",
"Xc c #DE5858",
"Xv c #D52B2B",
"Xb c #CF2525",
"Xn c #AE1515",
"Xm c #DFABAB",
"XM c #D44E4E",
"XN c #DC6363",
"XB c #FFFFFF",
"XV c #DB4B4B",
"XC c #D21E1E",
"XZ c #CF3232",
"XA c #B72121",
"XS c #DABDBD",
"XD c #BE1E1E",
"XF c #D83E3E",
"XG c #DCCCCC",
"XH c #424242",
"XJ c #D75454",
"XK c #DF6969",
"XL c #CD0F0F",
"XP c #D78282",
"XI c #D43A3A",
"XU c #DC4F4F",
"XY c #EFEFEF",
"XT c #A30000",
"XR c #EDEDED",
"XE c #EBEBEB",
"XW c #D53131",
"XQ c #E9E9E9",
"X! c #8F0000",
"X~ c #090000",
"X^ c #D67777",
"X/ c #B42121",
"X( c #E7E7E7",
"X) c #D94242",
"X_ c #D01515",
"X` c #E5E5E5",
"X' c #B71A1A",
"X] c #E3E3E3",
"X[ c #DD5353",
"X{ c #E1E1E1",
"X} c #DFDFDF",
"X| c #A20202",
"o  c #DDDDDD",
"o. c #A00000",
"oX c #D54B4B",
"oo c #C31F1F",
"oO c #DA4646",
"o+ c #D11919",
"o@ c #D95C5C",
"o# c #C03333",
"o$ c #DAA2A2",
"o% c #D3D3D3",
"o& c #A50808",
"o* c #E06666",
"o= c #D99797",
"o- c #181818",
"o; c #9D0000",
"o: c #DB4A4A",
"o> c #C7C7C7",
"o, c #DDD6D6",
"o< c #CC4545",
"o1 c #D25858",
"o2 c #E16A6A",
"o3 c #D83D3D",
"o4 c #C02C2C",
"o5 c #DD6666",
"o6 c #D32121",
"o7 c #AD1616",
"o8 c #DEDADA",
"o9 c #CF1D1D",
"o0 c #CC0303",
"oq c #D67676",
"ow c None",
/* pixels */
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowow./././ nowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowow nX/ 8XNXq nowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowX% Z._X;X4X@owowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowXT.L o.B.B <X+./owowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowow.H.8 N.B.B.K HXnowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowow n.!.^.B.B.B.B.NXM./owowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowow.Ro2X3.BXZ.y.B [X1 wowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowow n - ].B g.q.1Xe.B.T.A./owowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowow.U , [.B.G.so Xy.B.BXaXAowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowo. 9Xs.Bo0XSo o X=.[.BXo...powowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowow B.>.B.Bo1o o o .t.#.B.Bo: (o.owowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowow.p ).F.B $ 2o o .t.t.5XL.B O.CX|owowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowow.eXc.B.BX o o .t.tX}X}oq.B.B j y./owowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowXko5Xz.B.lXGo .t.tX}X}X} 5.(.B ^ !Xhowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowo.o#.Y.B.B ;o .t.tX}X}X}.w.w.o.B.B < Q./owowowowowowowowowowowowowow",
"owowowowowowowowowowowowowow :XK O.BX6 =.t.t 1 h h.].wX{.So9.B.iXgo&owowowowowowowowowowowowowow",
"owowowowowowowowowowowowow./ Uo:.B.BX^.t.tX}XH    . X{X{.0X>.B.B fX#./owowowowowowowowowowowowow",
"owowowowowowowowowowowowow ~X5 t.B.go,.tX}X} /     /X{.0.0X7 e.B N.%.howowowowowowowowowowowowow",
"owowowowowowowowowowowow n uXu.B.BXP.tX}X}.wXx     R.0.0.0X]X*.B.BXs 6./owowowowowowowowowowowow",
"owowowowowowowowowowowow E.X K.B.:o8X}X}.w.w S    Xi.0.0X].9.9 T.BX3XX Yowowowowowowowowowowowow",
"owowowowowowowowowowow no< r.B.B {X}X}.w.w.wX9    X9X]X].9.9X`Xm.B.B.F.}./owowowowowowowowowowow",
"owowowowowowowowowowowX:.Z $.BXb bX}.w.w.wX{ a    X,X].9.9X`X`.7Xf.B [X).aowowowowowowowowowowow",
"owowowowowowowowowow./X<.^.B.Bo=X}.w.w.wX{X{X&     0.9.9X`X`.7.7 W.B.Bo+.y./owowowowowowowowowow",
"owowowowowowowowowow.&o*.K.B CX}.w.w.wX{X{.0.]     >.9X`X`.7.7X(X(oX.B.B.kXjowowowowowowowowowow",
"owowowowowowowowow./X0 ].B.Bo$.w.w.wX{X{.0.0 %     %X`X`.7.7X(X(.3 Go0.B k.W.powowowowowowowowow",
"owowowowowowowowow | # g.B.=.w.w.wX{X{.0.0X].M F Fo>X`.7.7X(X(.3XQXQ A.B.B MX'o.owowowowowowowow",
"owowowowowowowow./XpXs.B.B @.w.wX{X{.0.0X]X].9.Mo>X`.7.7X(X(.3XQXQ.2 X N.B ^XI Lowowowowowowowow",
"owowowowowowowow V d [.B.V.w.wX{X{.0.0X]X].9Xr  .PX9.7X(.3.3XQXQ.2.2XEXw.B.BXv ../owowowowowowow",
"owowowowowowow.po@o6.B [ l.wX{X{.0.0X]X].9.9.b    o-X(.3.3XQXQ.2.2XEXE.x.[.B.i iXkowowowowowowow",
"owowowowowowow.Q.).B.B.v.wX{X{.0.0X]X].9.9X` `     }.3.3XQXQ.2.2XEXE.-.-.I.B.B.TXD nowowowowowow",
"owowowowowowX|X.Xo.Bo0XOX{X{.0.0X]X].9.9X`X`o% c co%.3XQXQ.2.2XEXE.-.-XR z x.B N P :owowowowowow",
"owowowowow./ DXU.B.B.'X{X{.0.0X]X].9.9X`X`.7X(X(.3.3XQXQ.2.2XEXE.-XRXR.*.*.O.B.BXC.n./owowowowow",
"owowowowowXk.cX_.B N.EX{.0.0X]X].9.9X`X`.7X(X(.3.3XQXQ.2.2XEXE.-XRXR.*.*XY.d.f.BX3XWXdowowowowow",
"owowowow 7o4X-.B.B C.+.0.0X]X].9.9X`X`.7X(X(.3.3XQXQ.2.2XEXE.-XRXR.*.*XYXY.@.u.B.BXzooo.owowowow",
"owowowow.| A 4.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.KXto.owowowow",
"owowowow _.$ f.<.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B.B g t +o.owowowow",
"owowowow qo7XJ.~ , # m.JX1 'X$Xc.j.)X[.YX8XU.DXVo:XXoO *XuX) jXFo3 r.k < J.^ M.,X2 +.4 sowowowow",
"owowowowow.6o; I 3.z.z.z.z.z.z.z.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{.{XlXlXl 3 I IX!owowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow",
"owowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowowow"
};


// ---------------------------------------------------------------------
// end of Tango icons
// ---------------------------------------------------------------------
